% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo.onedim.R
\name{pseudo.onedim}
\alias{pseudo.onedim}
\title{Function that computes univariate pseudo-observations}
\usage{
pseudo.onedim(tstart, tstop, status, covar_names, id, tk, data)
}
\arguments{
\item{tstart}{Start time - expecting counting process notation}

\item{tstop}{Stop time - expecting counting process notation}

\item{status}{Status variable (0 = censoring, 1 = recurrent event, 2 = death)}

\item{covar_names}{Vector containing names of covariates intended for further analysis}

\item{id}{ID variable for subject}

\item{tk}{Vector of time points to calculate pseudo-observations at}

\item{data}{Data set which contains variables of interest}
}
\value{
An object of class \code{pseudo.onedim}.
\itemize{
\item{\code{outdata}} {contains the semi-wide version of the computed pseudo-observations (one row per time, tk, per id).}
\item{\code{outdata_long}} {contains the long version of the computed pseudo-observations (one row per observation, several per id).}
\item{\code{indata}} {contains the input data which the pseudo-observations are based on.}
\item{\code{ts}} {vector with time points used for computation of pseudo-observations.}
\item{\code{k}} {number of time points used for computation of pseudo-observations (length(ts)).}
}
}
\description{
This function computes univariate pseudo-observations of the marginal mean function
(in the presence of terminal events)
}
\examples{
# Example: Bladder cancer data from survival package
require(survival)

# Make a three level status variable
bladder1$status3 <- ifelse(bladder1$status \%in\% c(2, 3), 2, bladder1$status)

# Add one extra day for the two patients with start=stop=0
# subset(bladder1, stop <= start)
bladder1[bladder1$id == 1, "stop"] <- 1
bladder1[bladder1$id == 49, "stop"] <- 1

# Restrict the data to placebo and thiotepa
bladdersub <- subset(bladder1, treatment \%in\% c("placebo", "thiotepa"))

# Make treatment variable two-level factor
bladdersub$Z <- as.factor(ifelse(bladdersub$treatment == "placebo", 0, 1))
levels(bladdersub$Z) <- c("placebo", "thiotepa")
head(bladdersub)

# Pseudo observations
pseudo_bladder_1d <- pseudo.onedim(tstart = bladdersub$start,
                                   tstop = bladdersub$stop,
                                   status = bladdersub$status3,
                                   id = bladdersub$id,
                                   covar_names = "Z",
                                   tk = c(30),
                                   data = bladdersub)
head(pseudo_bladder_1d$outdata)

# GEE fit
fit_bladder_1d <- pseudo.geefit(pseudodata = pseudo_bladder_1d,
                                covar_names = c("Z"))
fit_bladder_1d
}
\references{
Furberg, J.K., Andersen, P.K., Korn, S. et al. Bivariate pseudo-observations for recurrent event analysis with terminal events. Lifetime Data Anal (2021). https://doi.org/10.1007/s10985-021-09533-5
}
\keyword{recurrentpseudo}
