% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refset.R
\name{contents}
\alias{contents}
\alias{contents<-}
\title{Returns or changes parcel contents}
\usage{
contents(parcel)

contents(parcel) <- value
}
\arguments{
\item{parcel}{an object of class 'parcel'}

\item{value}{a value to assign}
}
\value{
The result of evaluating the expression stored in the parcel. 
For \code{contents<-}, the parcel itself.

\code{contents<-} will only work if the expression wrapped in the
parcel can accept assignments.
}
\description{
\code{contents} returns the value of the parcel contents by evaluating
the expression in the parcel. \code{contents<-} attempts to assign
to the expression, which will only work if the expression is appropriate, e.g.
a refset.
}
\examples{
pcl <- wrap(x^2)
x <- 2
contents(pcl)
x <- 3
contents(pcl)
\dontrun{
contents(pcl) <- 4 # fails
}
p2 <- wrap(names(x))
contents(p2) <- "named"
x

}
\seealso{
Other wrapping functions: \code{\link{is.parcel}},
  \code{\link{unwrap_as}}, \code{\link{wrapset}},
  \code{\link{wrap}}
}
