% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IRLS_EM}
\alias{IRLS_EM}
\title{Iterative Reweighted Least Squares for the EM algorithm}
\usage{
IRLS_EM(X, gamma, Y, beta, family, eps_IRLS, max_N)
}
\arguments{
\item{X}{A design matrix of size n x p.}

\item{gamma}{A vector of size n specifying the posterior probability of the hidden states.}

\item{Y}{A vector of observations of size n.}

\item{beta}{A vector of size p + 1 specifying the GLM parameters.}

\item{family}{The family of the response.}

\item{eps_IRLS}{convergence tolerance in the iteratively reweighted least squares step.}

\item{max_N}{the maximal number of IRLS iterations.}
}
\value{
A vector representing the estimates of beta.
}
\description{
Iterative Reweighted Least Squares algorithm for optimizing the parameters in the M-step of the EM algorithm.
}
\examples{
\dontrun{
# Example usage of the function
IRLS_EM_one_step <- IRLS_EM_one(X,
                                gamma,
                                Y,
                                beta,
                                family)
}
}
