% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XL-class.R
\docType{class}
\name{XL-class}
\alias{XL-class}
\alias{show,XL-method}
\title{Excess of Loss Treaty}
\usage{
\S4method{show}{XL}(object)
}
\arguments{
\item{object}{the object to display}
}
\description{
An S4 class to represent an Excess of Loss Treaty
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Excess of Loss Treaty: show method
}}

\section{Slots}{

\describe{
\item{\code{ded}}{Numeric. Deductible amount of the treaty. Should be superior to 0.}

\item{\code{lim}}{Numeric. Limit amount for the treaty. Should be superior to 0. May be equal to \code{Inf}.}

\item{\code{aal}}{Numeric. Annual Aggregate Deductible amount of the treaty. Should be superior to 0.}

\item{\code{aad}}{Numeric. Annual Aggregate Limit amount for the treaty. Should be superior to 0. May be equal to \code{Inf}.}

\item{\code{rns}}{Numeric vector. Reinstatement prices. Vector of lentgh equals to the number of reinstatements with each value equals the price of the reinstatement.}

\item{\code{prm}}{Numeric. Premium rate, which represents the proportion of the premium given to the reinsurer as price for the treaty. Should be between 0 and 1.}

\item{\code{ptf}}{Vector. List of portfolios on which the treaty is to be applied on.}

\item{\code{trt}}{Character. Always equal to "SL". Identifier for the type of treaty}
}}

