% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\docType{methods}
\name{draw}
\alias{draw}
\alias{draw,Claims-method}
\title{Claims: Plot function}
\usage{
draw(x, value = "all", moment = "gain", output = "boxplot")

\S4method{draw}{Claims}(x, value = "all", moment = "gain",
  output = "boxplot")
}
\arguments{
\item{x}{The Claims object to represent.}

\item{value}{Character. The value to consider plot, among:
\itemize{
 \item{\code{claims}}
 \item{\code{premiums}}
 \item{\code{reinstatements}}
 \item{\code{commissions}}
 \item{\code{all}: default value. Compute the profit.}
}}

\item{moment}{Character. Moment for analysis:
\itemize{
 \item{\code{before}: before reinsurance;}
 \item{\code{after}: after reinsurance;}
 \item{\code{gain}: default value. Difference in values by application of reinsurance.}
}}

\item{output}{Character. Type of graph to produce:
\itemize{
\item{\code{boxplot}: default value. Boxplot by year}
\item{\code{histogram}: histogram over all years}
}}
}
\value{
a plot
}
\description{
\code{draw} produces a graphical representation of an object \code{Claims} (\code{\link{Claims-class}}).
}
\details{
For boxplots, a red dot represent the mean value for each year.
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)
p <- aggregate(amount ~ year, c, sum)
claims <- claims(c, p)
treaty_1 <- xl(ded = 100000, lim = 20000, aad = 5000,
               aal = 200000, prm = 0.01, rns = 1)
claims <- apply_treaty(claims, treaty_1)
draw(claims)

}
