% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL-class.R
\name{sl}
\alias{sl}
\title{Stop Loss Treaty: User constructor function}
\usage{
sl(ded = Inf, lim = Inf, prm = 0, ptf = "all")
}
\arguments{
\item{ded}{Numeric. Deductible amount of the treaty. Should be superior to 0.}

\item{lim}{Numeric. Limit amount for the treaty. Should be superior to 0. May be equal to \code{Inf}.}

\item{prm}{Numeric. Premium rate, which represents the proportion of the premium given to the reinsurer as price for the treaty. Should be between 0 and 1.}

\item{ptf}{Vector. List of portfolios on which the treaty is to be applied on. Default value set to all.}
}
\value{
An object of class \code{SL} (\code{\link{SL-class}}), initialized with the values given in input. Its basic methods are:
\itemize{
 \item{\code{show}}
}
}
\description{
\code{sl} defines an object of class \code{SL} (\code{\link{SL-class}}), which represents a Stop Loss treaty.
}
\examples{
treaty_1 <- sl(ded = 100000, lim = 20000, prm = 0.01, ptf = "all")
treaty_1

}
