% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial-functions.R
\name{distm_km}
\alias{distm_km}
\alias{distm_scaled}
\title{Calculate a distance matrix from coordinates}
\usage{
distm_km(coords, coords2 = NULL)

distm_scaled(coords, coords2 = NULL, distm_FUN = "distm_km")
}
\arguments{
\item{coords}{a coordinate matrix with 2 columns and rows corresponding to
each location.}

\item{coords2}{an optional coordinate matrix}

\item{distm_FUN}{function used to calculate the distance matrix. This function
dictates the units of "max.dist"}
}
\value{
\code{distm_km} returns a distance matrix in km

A distance matrix is returned.

If \code{coords2 = NULL}, then distances among points in \code{coords} are
calculated. Otherwise, distances are calculated between points in \code{coords}
and \code{coords2}

\code{distm_km} returns a distance matrix in km and \code{distm_scaled} returns
relative distances (between 0 and 1). The resulting matrix has the attribute
"max.dist" which stores the maximum distance of the map. "max.dist" is in
km for \code{distm_km} and in the units of \code{distm_FUN} for \code{distm_scaled}.
}
\description{
Calculate the distances among points from a single coordinate matrix
or
}
\details{
\code{distm_km} is simply a wrapper for \code{geosphere::distm()}
}
\examples{
map.width = 3 # square map width
coords = expand.grid(x = 1:map.width, y = 1:map.width) # coordinate matrix
distm_scaled(coords) # calculate relative distance matrix

}
\seealso{
\code{?geosphere::distm()}
}
