% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_qq.R
\name{nice_qq}
\alias{nice_qq}
\title{Easy QQ plots per group}
\usage{
nice_qq(
  data,
  variable,
  group = NULL,
  colours,
  groups.labels = NULL,
  grid = TRUE,
  shapiro = FALSE,
  title = variable
)
}
\arguments{
\item{data}{The data frame.}

\item{variable}{The dependent variable to be plotted.}

\item{group}{The group by which to plot the variable.}

\item{colours}{Desired colours for the plot, if desired.}

\item{groups.labels}{How to label the groups.}

\item{grid}{Logical, whether to keep the default background
grid or not. APA style suggests not using a grid in the
background, though in this case some may find it useful
to more easily estimate the slopes of the different groups.}

\item{shapiro}{Logical, whether to include the p-value
from the Shapiro-Wilk test on the plot.}

\item{title}{An optional title, if desired.}
}
\value{
A qq plot of class ggplot, by group (if provided), along a
reference interpretation helper, the 95\% confidence band.
}
\description{
Easily make nice per-group QQ plots through
a wrapper around the \code{ggplot2} and \code{qqplotr} packages.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE) && requireNamespace("ggrepel", quietly = TRUE) && requireNamespace("qqplotr", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Make the basic plot
nice_qq(
  data = iris,
  variable = "Sepal.Length",
  group = "Species"
)

# Further customization
nice_qq(
  data = iris,
  variable = "Sepal.Length",
  group = "Species",
  colours = c("#00BA38", "#619CFF", "#F8766D"),
  groups.labels = c("(a) Setosa", "(b) Versicolor", "(c) Virginica"),
  grid = FALSE,
  shapiro = TRUE,
  title = NULL
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_assumptions}}, \code{\link{nice_density}},
\code{\link{nice_normality}}, \code{\link{nice_var}},
\code{\link{nice_varplot}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{QQ}
\keyword{distribution}
\keyword{normality}
\keyword{plots}
