% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_deps.R
\name{list_deps}
\alias{list_deps}
\title{List dependencies of reports within a factory}
\usage{
list_deps(
  factory = ".",
  missing = FALSE,
  check_r = TRUE,
  exclude_readme = TRUE,
  parse_first = FALSE
)
}
\arguments{
\item{factory}{The path to the report factory or a folder within the desired
factory. Defaults to the current directory.}

\item{missing}{A logical indicating if only missing dependencies should be
listed (\code{TRUE}); otherwise, all packages needed in the reports are listed;
defaults to \code{FALSE}.}

\item{check_r}{If true, R scripts contained within the factory will also be
checked. Note that this will error if the script cannot be parsed.}

\item{exclude_readme}{If TRUE (default) README files will not be checked for
dependencies.}

\item{parse_first}{If \code{TRUE} code will first be parsed for validity and
unevaluated Rmd chunks will not be checked for dependencies. The default
value is \code{FALSE} and, in this case, files will simply be checked line by
line for calls to \code{library}, \code{require} or use of double, \code{::}, and triple,
\code{:::} function calls.}
}
\value{
A character vector of package dependencies.
}
\description{
List package dependencies based on the reports and scripts within the
report_sources and scripts directories respectively.
}
\note{
This function requires that any R scripts present in the factory are
valid syntax else the function will error.
}
