% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{metaanalyse.Cliffd}
\alias{metaanalyse.Cliffd}
\title{metaanalyse.Cliffd}
\usage{
metaanalyse.Cliffd(
  Cliffd,
  Cliffdvar,
  df = 0,
  alternative = "two.sided",
  alpha = 0.05
)
}
\arguments{
\item{Cliffd}{A vector of one or more numerical values, identifying the effect sizes to be meta-analysed}

\item{Cliffdvar}{A vector of the estimates variance of each of the effect sizes}

\item{df}{The total degrees of freedom for the set of effect sizes. If df>0, the pvalues and significance test use the t-distribution probability values. If df=0 (default) the pvalues and significance test use the normal distribution probability values. The confidence intervals are always based on the normal probability values, as recommended by Cliff.}

\item{alternative}{Specifies the type of significance test and can take the values "two.sided" (default), "less" or "greater".}

\item{alpha}{The significance level used to control the significance tests and calculation of confidence limits (default 0.05).}
}
\value{
Estimate The overall estimate of Cliff's d obtained from the set of experiments

UpperCI The upper 100*(1-alpha/2)% confidence interval based on the normal probability value

LowerCI The lower 100*(1-alpha/2)% confidence interval based on the normal probability value

The variance of the Estimate

tvalue The value of the t-statistic

df The supplied degrees of freedom or NA if the input parameter df was set to zero

AltHyp Defines the alternative hypothesis used for significance testing and depends on the value of the input parameter alternative. It takes the values "Not=0", ">0", or "<0"

NullHyp Defines the null hypothesis and depends on the value of the input parameter alternative. It takes the values "~0", "<0", or ">0"

pvalue The p-value of the t-test if the parameter df>0, or the normal probability value if d=0

RejectNullHyp "Yes" or "No" depending on whether or not the null hypothesis should be rejected at the alpha/2 level for two-sided tests and alpha level for one-sided tests

The Q homogeneity statistic

The I-squared estimate of the extent of heterogeneity

ProbQHomogeneous. The probability that the set of Cliff's d values come from a set of homogeneous experiments.
}
\description{
This function provides a simple meta-analysis of experiments using Cliff's d as an effect size. It returns the 100*(1-alpha/2)% confidence intervals based on the normal distribution probability values, the value of the t-test, the probability asssociated with the null hypothesis and the significance of the test. The pvalue and the significance vary according to the value of the parameter "alternative" and whether or not degrees of freedom are specifed. It also return the heterogeneity statistics Q and I-squared.
}
\examples{
Cliffd=c(0.84,0.2,-0.04,0.44,0.76)
CliffdvarInvalid=c(0.04,0.18,0.21,0.15)
Cliffdvar=c(0.04,0.18,0.21,0.15,0.06)
CliffdvarInvalid=c(0.04,0.18,0.21,0.15)
df=45
as.data.frame(metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=Cliffdvar,df=df,alternative="greater",
 alpha=0.05))
#  Estimate   UpperCI   LowerCI Variance tvalue df AltHyp NullHyp      pvalue
#1     0.44 0.6601381 0.1502568   0.0256   2.75 45     >0     <=0 0.004275955
#  RejectNullHyp    Q I.square ProbQHomogeneous
#1           Yes 21.5 81.39535     0.0002519835
as.data.frame(metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=Cliffdvar,df=df,alternative="less",
 alpha=0.05))
#  Estimate   UpperCI   LowerCI Variance tvalue df AltHyp NullHyp   pvalue RejectNullHyp
#1     0.44 0.6601381 0.1502568   0.0256   2.75 45     <0     >=0 0.995724            No
#     Q I.square ProbQHomogeneous
#1 21.5 81.39535     0.0002519835
as.data.frame(metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=Cliffdvar,df=df,alternative="two.sided",
 alpha=0.05))
#  Estimate  UpperCI    LowerCI Variance tvalue df AltHyp NullHyp      pvalue
#1     0.44 0.692073 0.09227496   0.0256   2.75 45  Not=0      ~0 0.008551911
#  RejectNullHyp    Q I.square ProbQHomogeneous
#1           Yes 21.5 81.39535     0.0002519835
as.data.frame(metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=Cliffdvar,df=df,alpha=0.05))
#  Estimate  UpperCI    LowerCI Variance tvalue df AltHyp NullHyp      pvalue
#1     0.44 0.692073 0.09227496   0.0256   2.75 45  Not=0      ~0 0.008551911
#  RejectNullHyp    Q I.square ProbQHomogeneous
#1           Yes 21.5 81.39535     0.0002519835
metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=Cliffdvar,df=0,alternative="two.sided",alpha=0.05)
#Error in testfunctionParameterChecks(alternative = alternative, alpha = alpha,  :
#  Invalid alternative parameter, choose one of two.sided, greater or less
# metaanalyse.Cliffd(Cliffd=Cliffd,Cliffdvar=CliffdvarInvalid,df=df,alternative="greater",
# alpha=0.05)
#Error in metaanalyse.Cliffd(Cliffd = Cliffd, Cliffdvar = CliffdvarInvalid,  :
#  Length of Cliffdvar parameter must equal the length of the Cliffd parameter
}
\author{
Barbara Kitchenham and Lech Madeyski
}
