% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{checkRelative}
\alias{checkRelative}
\title{An alternative to \code{basename} and \code{dirname} when there are sub-folders}
\usage{
checkRelative(
  files,
  absolutePrefix,
  knownRelativeFiles,
  verbose = getOption("reproducible.verbose")
)
}
\arguments{
\item{files}{A character vector of files to check to see if they are the same
as \code{knownRelativeFiles}, once the \code{absolutePrefix} is removed}

\item{absolutePrefix}{A directory to "remove" from \code{files} to compare
to \code{knownRelativeFiles}}

\item{knownRelativeFiles}{A character vector of relative filenames, that could
have sub-folder structure.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\description{
This confirms that the \code{files} which may be absolute actually
exist when compared \code{makeRelative(knownRelativeFiles, absolutePrefix)}.
This is different than just using \code{basename} because it will include any
sub-folder structure within the \code{knownRelativePaths}
}
