% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{clean_names_rdbr}
\alias{clean_names_rdbr}
\title{Clean and standardize column names in a data.frame}
\usage{
clean_names_rdbr(
  df,
  case = c("snake", "lower_camel", "upper_camel", "screaming_snake"),
  replace_special_chars = TRUE,
  unique_names = TRUE
)
}
\arguments{
\item{df}{A data.frame or tibble whose column names you want to clean.}

\item{case}{The case format for the resulting names. Options:
\code{"snake"} (default): names_with_underscores
\code{"lower_camel"}: namesWithCamelCase
\code{"upper_camel"}: NamesWithCamelCase
\code{"screaming_snake"}: NAMES_WITH_UNDERSCORES}

\item{replace_special_chars}{Logical. If \code{TRUE} (default), replaces accented
and special characters with their ASCII equivalents (e.g., "a with accent" becomes "a").}

\item{unique_names}{Logical. If \code{TRUE} (default), ensures the resulting names
are unique by adding numeric suffixes to duplicates.}
}
\value{
A data.frame with the same data as the input but with clean and standardized
column names according to the specified parameters.
}
\description{
This function standardizes column names in a data.frame to make them syntactically
valid and consistent. It converts uppercase to lowercase, removes spaces and special
characters, replaces accents, and ensures names are unique and valid for R. It is an
alternative to the \code{janitor::clean_names()} function implemented in base R.
}
\details{
The cleaning process includes:
\itemize{
\item Converting everything to lowercase (except in camel or screaming_snake formats)
\item Replacing accents and common special characters with their ASCII equivalents
\item Removing parentheses and their content
\item Replacing non-alphanumeric characters with underscores
\item Removing redundant underscores (leading, trailing, or duplicated)
\item Ensuring names don't start with numbers (adding "x" at the beginning)
\item Applying the selected case format
\item Ensuring names are unique by adding numeric suffixes
}
}
\keyword{internal}
