% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_val_check.R
\name{cross_val_check}
\alias{cross_val_check}
\title{Cross validation check for spline in time, spline in space time and GAM in order to select the most appropriate number of knots when creating basis functions.}
\usage{
cross_val_check(
  data,
  prediction_grid_res = 50,
  spline_nseg = NULL,
  spline_nseg_t = 20,
  spline_nseg_st = 6,
  n_iterations = 1000,
  n_burnin = 100,
  n_thin = 5,
  n_chains = 2,
  model_type,
  n_fold = 5,
  seed = NULL,
  CI = 0.95
)
}
\arguments{
\item{data}{Raw input data}

\item{prediction_grid_res}{Resolution of grid. Predictions over every 50 years(default) can vary based on user preference, as larger values will reduce computational run time.}

\item{spline_nseg}{This setting is focused on the Noisy Input Spline model. It provides the number of segments used to create basis functions.}

\item{spline_nseg_t}{This setting is focused on the Noisy Input Generalised Additive Model. It provides the number of segments used to create basis functions.}

\item{spline_nseg_st}{This setting is focused on the Noisy Input Generalised Additive Model. It provides the number of segments used to create basis functions.}

\item{n_iterations}{Number of iterations. Increasing this value will increase the computational run time.}

\item{n_burnin}{Size of burn-in. This number removes a certain number of samples at the beginning.}

\item{n_thin}{Amount of thinning.}

\item{n_chains}{Number of MCMC chains. The number of times the model will be run.}

\item{model_type}{The user selects their statistical model type. The user can select a Noisy Input Spline in Time using "ni_spline_t". The user can select a Noisy Input Spline in Space Time using "ni_spline_st". The user can select a Noisy Input Generalised Additive Model using "ni_gam_decomp".}

\item{n_fold}{Number of folds required in the cross validation. The default is 5 fold cross validation.}

\item{seed}{If the user wants reproducible results, seed stores the output when random selection was used in the creation of the cross validation.}

\item{CI}{Size of the credible interval required by the user. The default is 0.95 corresponding to 95\%.}
}
\value{
A list containing the model comparison measures, e.g. Root Mean Square Error (RMSE), and plot of true vs predicted values
}
\description{
Cross validation check for spline in time, spline in space time and GAM in order to select the most appropriate number of knots when creating basis functions.
}
\examples{
\donttest{
data <- NAACproxydata \%>\% dplyr::filter(Site == "Cedar Island")
cross_val_check(data = data, model_type = "ni_spline_t",n_fold = 2)
}
}
