/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Random;
import org.chocosolver.sat.Clause;
import org.chocosolver.sat.Dimacs;
import org.chocosolver.sat.Reason;
import org.chocosolver.sat.SatFactory;
import org.chocosolver.solver.variables.impl.LitVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.IntHeap;

public class MiniSat
implements SatFactory,
Dimacs {
    private static final int DEBUG = 0;
    private static final int varUndef = -1;
    private static final int litUndef = -2;
    public static final int lTrue = 1;
    public static final int lFalse = 2;
    public static final int lUndef = 3;
    protected static ThreadLocal<Integer> clauseCounter = ThreadLocal.withInitial(() -> 0);
    public static final Clause C_Undef = Clause.undef();
    private static final Reason R_Undef = Reason.undef();
    static final VarData VD_Undef = new VarData(R_Undef, -1, -1);
    public Clause confl = C_Undef;
    public static final Clause C_Fail = new Clause(new int[]{0, 0});
    static final ChannelInfo CI_Null = new ChannelInfo(null, 0, 0, 0);
    public boolean ok_ = true;
    public final ArrayList<Clause> clauses = new ArrayList();
    private final ArrayList<Clause> learnts = new ArrayList();
    private final TIntObjectHashMap<ArrayList<Watcher>> watches_ = new TIntObjectHashMap();
    TIntArrayList assignment_ = new TIntArrayList();
    TIntArrayList trail_ = new TIntArrayList();
    TIntArrayList trail_markers_ = new TIntArrayList();
    int qhead_ = 0;
    int num_vars_ = 0;
    int rootlvl = 0;
    int ccmin_mode = 0;
    int phase_saving = 0;
    double cla_inc = 1.0;
    double var_inc = 1.0;
    double var_decay = 0.95;
    double clause_decay = 0.999;
    double random_var_freq = 0.0;
    int restart_inc = 2;
    boolean rnd_init_act = true;
    boolean luby_restart = true;
    int restart_first = 100;
    int random_seed = 7;
    double learntsize_adjust_confl = 100.0;
    int learntsize_adjust_cnt = 100;
    double learntsize_adjust_inc = 1.5;
    double learntsize_inc = 1.1;
    double learntsize_factor = 0.3333333333333333;
    boolean rnd_pol;
    int conflict_budget = -1;
    int propagation_budget = -1;
    int propagations;
    int rnd_decisions;
    boolean asynch_interrupt = false;
    TIntArrayList model = new TIntArrayList();
    TIntArrayList conflict = new TIntArrayList();
    ArrayList<VarData> vardata = new ArrayList();
    ArrayList<ChannelInfo> cinfo = new ArrayList();
    int conflicts;
    int decisions;
    int max_literals;
    int tot_literals;
    int dec_vars;
    int clauses_literals;
    int learnts_literals;
    double max_learnts;
    BitSet seen = new BitSet();
    BitSet decision = new BitSet();
    BitSet polarity = new BitSet();
    TIntArrayList analyze_toclear = new TIntArrayList();
    TDoubleArrayList activity = new TDoubleArrayList();
    IntHeap order_heap = new IntHeap((a, b) -> this.activity.get(a) > this.activity.get(b));
    Random rand;
    private final TIntArrayList temporary_add_vector_ = new TIntArrayList();

    public MiniSat(boolean addTautology) {
        this.rand = new Random(this.random_seed);
        this.assignment_.add(3);
        if (addTautology) {
            int v = this.newVariable();
            int l = MiniSat.makeLiteral(v, true);
            this.assignment_.set(v, MiniSat.makeBoolean(MiniSat.sgn(l)));
            this.vardata.set(v, new VarData(R_Undef, this.trailMarker(), this.trail_.size()));
            this.trail_.add(l);
            this.seen.set(v);
            v = this.newVariable();
            l = MiniSat.makeLiteral(v, true);
            this.assignment_.set(v, MiniSat.makeBoolean(MiniSat.sgn(l)));
            this.vardata.set(v, new VarData(R_Undef, this.trailMarker(), this.trail_.size()));
            this.trail_.add(l);
            this.seen.set(v);
        }
        clauseCounter.set(2);
    }

    @Override
    public MiniSat _me() {
        return this;
    }

    public int newVariable() {
        return this.newVariable(CI_Null);
    }

    public int newVariable(ChannelInfo ci) {
        int v = this.incrementVariableCounter();
        assert (this.assignment_.size() == v + 1);
        this.assignment_.add(3);
        this.vardata.add(VD_Undef);
        this.cinfo.add(ci);
        this.activity.add(this.rnd_init_act ? this.rand.nextDouble() * 1.0E-5 : 0.0);
        this.seen.clear(v);
        this.polarity.set(v);
        if (!this.decision.get(v)) {
            ++this.dec_vars;
        }
        this.decision.set(v);
        this.insertVarOrder(v);
        return v;
    }

    private void insertVarOrder(int v) {
        if (!this.order_heap.contains(v) && this.decision.get(v)) {
            this.order_heap.insert(v);
        }
    }

    public void beforeAddingClauses() {
    }

    public void afterAddingClauses() {
    }

    public boolean addClause(TIntList ps) {
        assert (0 == this.trailMarker());
        if (!this.ok_) {
            return false;
        }
        ps.sort();
        int lit = -2;
        int j = 0;
        for (int i = 0; i < ps.size(); ++i) {
            if (this.valueLit(ps.get(i)) == 1 || ps.get(i) == MiniSat.neg(lit)) {
                return true;
            }
            if (this.valueLit(ps.get(i)) == 2 || ps.get(i) == lit) continue;
            lit = ps.get(i);
            ps.set(j++, lit);
        }
        if (j < ps.size()) {
            ps.remove(j, ps.size() - j);
        }
        switch (ps.size()) {
            case 0: {
                this.ok_ = false;
                return false;
            }
            case 1: {
                this.uncheckedEnqueue(ps.get(0));
                this.propagate();
                this.ok_ = this.confl == C_Undef;
                return this.ok_;
            }
        }
        Clause cr = new Clause(ps);
        this.clauses.add(cr);
        this.attachClause(cr);
        return true;
    }

    public boolean addClause(int l) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(l);
        return this.addClause(this.temporary_add_vector_);
    }

    public boolean addClause(int p, int q) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        return this.addClause(this.temporary_add_vector_);
    }

    public boolean addClause(int p, int q, int r) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        this.temporary_add_vector_.add(r);
        return this.addClause(this.temporary_add_vector_);
    }

    public void addLearnt(TIntList learnt_clause) {
        for (int v = 0; v < this.nVars(); ++v) {
            assert (this.valueVar(v) != 3 || this.order_heap.contains(v)) : v + " not heaped";
        }
        if (learnt_clause.size() == 1) {
            this.uncheckedEnqueue(learnt_clause.get(0));
        } else {
            Clause cr = new Clause(learnt_clause, true);
            this.learnts.add(cr);
            this.attachClause(cr);
            this.claBumpActivity(cr);
            this.uncheckedEnqueue(learnt_clause.get(0), Reason.r(cr));
        }
        this.varDecayActivity();
        this.claDecayActivity();
        if (--this.learntsize_adjust_cnt == 0) {
            this.learntsize_adjust_confl *= this.learntsize_adjust_inc;
            this.learntsize_adjust_cnt = (int)this.learntsize_adjust_confl;
            this.max_learnts *= this.learntsize_inc;
        }
    }

    public void cancel() {
        this.cancelUntil(this.trailMarker() - 1);
    }

    public void cancelUntil(int level) {
        if (this.trailMarker() > level) {
            for (int c = this.trail_.size() - 1; c >= this.trail_markers_.get(level); --c) {
                int x = MiniSat.var(this.trail_.get(c));
                this.assignment_.set(x, 3);
                if (this.phase_saving > 1 || this.phase_saving == 1 && c > this.trail_markers_.get(this.trail_markers_.size() - 1)) {
                    this.polarity.set(x, MiniSat.sgn(this.trail_.get(c)));
                }
                this.insertVarOrder(x);
            }
            this.qhead_ = this.trail_markers_.get(level);
            this.trail_.remove(this.trail_markers_.get(level), this.trail_.size() - this.trail_markers_.get(level));
            this.trail_markers_.remove(level, this.trail_markers_.size() - level);
        }
    }

    public int trailMarker() {
        return this.trail_markers_.size();
    }

    public void setRootLevel() {
        this.rootlvl = this.trailMarker();
        this.topLevelCleanUp();
    }

    public void topLevelCleanUp() {
        for (int i = 0; i < this.trail_.size(); ++i) {
            int x = MiniSat.var(this.trail_.get(i));
            this.seen.set(x);
        }
        this.max_learnts = (double)this.nClauses() * this.learntsize_factor;
        this.learntsize_adjust_confl = 100.0;
        this.learntsize_adjust_cnt = (int)this.learntsize_adjust_confl;
        this.simplify();
    }

    public int valueVar(int x) {
        return this.assignment_.getQuick(x);
    }

    public int valueLit(int l) {
        return this.value(l, this.assignment_.getQuick(MiniSat.var(l)));
    }

    private int value(int l, int b) {
        if (b != 3) {
            if ((l & 1) != 0) {
                return b;
            }
            return b ^ 3;
        }
        return b;
    }

    public int nClauses() {
        return this.clauses.size();
    }

    public int nLearnts() {
        return this.learnts.size();
    }

    private int incrementVariableCounter() {
        return this.num_vars_++;
    }

    public int nVars() {
        return this.num_vars_;
    }

    public void pushTrailMarker() {
        this.trail_markers_.add(this.trail_.size());
    }

    public void uncheckedEnqueue(int l, Reason from) {
        assert (this.valueLit(l) == 3) : "l: " + this.printLit(l) + " from: " + from;
        int v = MiniSat.var(l);
        if (this.assignment_.getQuick(v) == 3) {
            this.onLiteralPushed(l);
        }
        this.assignment_.set(v, MiniSat.makeBoolean(MiniSat.sgn(l)));
        assert (this.vardata.size() >= v);
        VarData vd = this.vardata.get(v);
        if (vd != VD_Undef) {
            vd.set(from, this.trailMarker(), this.trail_.size());
        } else {
            this.vardata.set(v, new VarData(from, this.trailMarker(), this.trail_.size()));
        }
        this.trail_.add(l);
        this.cinfo.get(v).channel(MiniSat.sgn(l));
    }

    public void onLiteralPushed(int l) {
    }

    public void uncheckedEnqueue(int l) {
        this.uncheckedEnqueue(l, R_Undef);
    }

    public void cEnqueue(int l, Reason r) {
        assert (this.valueLit(l) != 1);
        int v = MiniSat.var(l);
        if (this.valueLit(l) == 2) {
            if (r == null || r == R_Undef) {
                this.confl = C_Fail;
            } else {
                this.confl = r.getConflict();
                this.confl._s(0, l);
            }
            return;
        }
        this.assignment_.set(v, MiniSat.makeBoolean(MiniSat.sgn(l)));
        assert (this.vardata.size() >= v);
        VarData vd = this.vardata.get(v);
        if (vd != VD_Undef) {
            vd.set(r, this.trailMarker(), this.trail_.size());
        } else {
            this.vardata.set(v, new VarData(r, this.trailMarker(), this.trail_.size()));
        }
        this.trail_.add(l);
    }

    void attachClause(Clause cr) {
        ArrayList<Watcher> l1;
        assert (cr.size() > 1);
        ArrayList<Watcher> l0 = this.watches_.get(MiniSat.neg(cr._g(0)));
        if (l0 == null) {
            l0 = new ArrayList();
            this.watches_.put(MiniSat.neg(cr._g(0)), l0);
        }
        if ((l1 = this.watches_.get(MiniSat.neg(cr._g(1)))) == null) {
            l1 = new ArrayList();
            this.watches_.put(MiniSat.neg(cr._g(1)), l1);
        }
        l0.add(new Watcher(cr, cr._g(1)));
        l1.add(new Watcher(cr, cr._g(0)));
        if (cr.learnt()) {
            this.learnts_literals += cr.size();
        } else {
            this.clauses_literals += cr.size();
        }
    }

    void detachClause(Clause cr) {
        int i;
        ArrayList<Watcher> ws = this.watches_.get(MiniSat.neg(cr._g(0)));
        for (i = ws.size() - 1; i >= 0 && ws.get((int)i).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
        ws = this.watches_.get(MiniSat.neg(cr._g(1)));
        for (i = ws.size() - 1; i >= 0 && ws.get((int)i).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
    }

    public boolean propagate() {
        this.confl = C_Undef;
        int num_props = 0;
        while (this.qhead_ < this.trail_.size()) {
            int p = this.trail_.get(this.qhead_++);
            ++num_props;
            this.propagateLit(p);
        }
        this.propagations += num_props;
        return this.confl == C_Undef;
    }

    private void propagateLit(int p) {
        ArrayList<Watcher> ws = this.watches_.get(p);
        int i = 0;
        int j = 0;
        while (ws != null && i < ws.size()) {
            int first;
            Watcher w = ws.get(i);
            int blocker = w.blocker;
            if (this.valueLit(blocker) == 1) {
                ws.set(j++, w);
                ++i;
                continue;
            }
            Clause cr = w.clause;
            int false_lit = MiniSat.neg(p);
            if (cr._g(0) == false_lit) {
                cr._s(0, cr._g(1));
                cr._s(1, false_lit);
            }
            assert (cr._g(1) == false_lit);
            ++i;
            w.blocker = first = cr._g(0);
            if (first != blocker && this.valueLit(first) == 1) {
                ws.set(j++, w);
                continue;
            }
            boolean cont = this.newWatch(cr, false_lit, w);
            if (cont) continue;
            ws.set(j++, w);
            if (this.valueLit(first) == 2) {
                this.confl = cr;
                this.qhead_ = this.trail_.size();
                while (i < ws.size()) {
                    ws.set(j++, ws.get(i++));
                }
                this.onLiteralPushed(first);
                continue;
            }
            this.uncheckedEnqueue(first, cr);
        }
        if (ws != null && ws.size() > j) {
            ws.subList(j, ws.size()).clear();
        }
    }

    private boolean newWatch(Clause cr, int false_lit, Watcher w) {
        for (int k = 2; k < cr.size(); ++k) {
            if (this.valueLit(cr._g(k)) == 2) continue;
            cr._s(1, cr._g(k));
            cr._s(k, false_lit);
            ArrayList<Watcher> lw = this.watches_.get(MiniSat.neg(cr._g(1)));
            if (lw == null) {
                lw = new ArrayList();
                this.watches_.put(MiniSat.neg(cr._g(1)), lw);
            }
            lw.add(w);
            return true;
        }
        return false;
    }

    public ESat solve() {
        this.model.clear();
        this.conflict.clear();
        if (!this.ok_) {
            return ESat.FALSE;
        }
        this.max_learnts = (double)this.nClauses() * this.learntsize_factor;
        this.learntsize_adjust_confl = 100.0;
        this.learntsize_adjust_cnt = (int)this.learntsize_adjust_confl;
        ESat status = ESat.UNDEFINED;
        int curr_restarts = 0;
        while (status == ESat.UNDEFINED) {
            double rest_base = this.luby_restart ? MiniSat.luby(this.restart_inc, curr_restarts) : Math.pow(this.restart_inc, curr_restarts);
            status = this.search((int)(rest_base * (double)this.restart_first));
            if (!this.withinBudget()) break;
            ++curr_restarts;
        }
        if (status == ESat.TRUE) {
            this.model.ensureCapacity(this.nVars());
            for (int i = 0; i < this.nVars(); ++i) {
                this.model.add(this.valueLit(i));
            }
        } else if (status == ESat.FALSE && this.conflict.isEmpty()) {
            this.ok_ = false;
        }
        this.cancelUntil(0);
        if (status == ESat.TRUE) {
            System.out.print("SAT\n");
            for (int i = 0; i < this.nVars(); ++i) {
                if (this.model.get(i) == 3) continue;
                System.out.printf("%s%s%d", i == 0 ? "" : " ", this.model.get(i) == 1 ? "" : "-", i + 1);
            }
            System.out.print(" 0\n");
        } else if (status == ESat.FALSE) {
            System.out.print("UNSAT\n");
        } else {
            System.out.print("INDET\n");
        }
        return status;
    }

    ESat search(int nof_conflicts) {
        assert (this.ok_);
        int conflictC = 0;
        TIntArrayList learnt_clause = new TIntArrayList();
        while (true) {
            this.propagate();
            if (this.confl != C_Undef) {
                ++this.conflicts;
                ++conflictC;
                if (this.trailMarker() == 0) {
                    return ESat.FALSE;
                }
                learnt_clause.clear();
                int backtrack_level = this.analyze(this.confl, learnt_clause);
                this.cancelUntil(backtrack_level);
                this.addLearnt(learnt_clause);
                continue;
            }
            if (nof_conflicts >= 0 && conflictC >= nof_conflicts || !this.withinBudget()) {
                this.cancelUntil(0);
                return ESat.UNDEFINED;
            }
            if (this.trailMarker() == 0 && !this.simplify()) {
                return ESat.FALSE;
            }
            if ((double)(this.learnts.size() - this.trail_.size()) >= this.max_learnts) {
                this.doReduceDB();
            }
            ++this.decisions;
            int next = this.pickBranchLit();
            if (next == -2) {
                return ESat.TRUE;
            }
            this.pushTrailMarker();
            this.uncheckedEnqueue(next, R_Undef);
        }
    }

    int pickBranchLit() {
        int next = -1;
        if (this.rand.nextDouble() < this.random_var_freq && !this.order_heap.isEmpty() && this.valueVar(next = this.order_heap.get(this.rand.nextInt(this.order_heap.size()))) == 3 && this.decision.get(next)) {
            ++this.rnd_decisions;
        }
        while (next == -1 || this.valueVar(next) != 3 || !this.decision.get(next)) {
            if (this.order_heap.isEmpty()) {
                next = -1;
                break;
            }
            next = this.order_heap.removeMin();
        }
        return next == -1 ? -2 : MiniSat.makeLiteral(next, this.rnd_pol ? this.rand.nextDouble() < 0.5 : this.polarity.get(next));
    }

    public int findConflictLevel() {
        int lvl = -1;
        for (int i = 0; i < this.confl.size(); ++i) {
            int l = this.vardata.get(MiniSat.var(this.confl._g(i))).level;
            if (l <= lvl) continue;
            lvl = l;
        }
        return lvl;
    }

    public int analyze(Clause confl, TIntArrayList out_learnt) {
        int pathC = 0;
        int p = -2;
        this.analyseConflict(confl, out_learnt, p, pathC);
        this.replaceUnreliableLits(out_learnt);
        int j = 1;
        this.analyze_toclear.resetQuick();
        this.analyze_toclear.addAll(out_learnt);
        if (this.ccmin_mode == 1) {
            j = 1;
            block0: for (int i = 1; i < out_learnt.size(); ++i) {
                int x = MiniSat.var(out_learnt.get(i));
                if (this.getConfl(x) == C_Undef) {
                    out_learnt.set(j++, out_learnt.get(i));
                    continue;
                }
                Clause c = this.getConfl(MiniSat.var(out_learnt.get(i)));
                for (int k = 1; k < c.size(); ++k) {
                    if (this.seen.get(MiniSat.var(c._g(k))) || this.level(MiniSat.var(c._g(k))) <= this.rootlvl) continue;
                    out_learnt.set(j++, out_learnt.get(i));
                    continue block0;
                }
            }
        } else {
            j = out_learnt.size();
        }
        this.max_literals += out_learnt.size();
        out_learnt.subList(j, out_learnt.size()).clear();
        this.tot_literals += out_learnt.size();
        int out_btlevel = this.getBacktrackLevel(out_learnt);
        for (j = 0; j < this.analyze_toclear.size(); ++j) {
            this.seen.clear(MiniSat.var(this.analyze_toclear.get(j)));
        }
        return out_btlevel;
    }

    private void analyseConflict(Clause confl, TIntList out_learnt, int p, int pathC) {
        out_learnt.add(-2);
        int index = this.trail_.size() - 1;
        do {
            int j;
            assert (confl != C_Undef);
            Clause c = confl;
            if (c.learnt()) {
                this.claBumpActivity(c);
            }
            int n = j = p == -2 ? 0 : 1;
            while (j < c.size()) {
                int q = c._g(j);
                int x = MiniSat.var(q);
                if (!this.seen.get(x) && this.level(x) > this.rootlvl) {
                    assert (p == -2 || this.pos(MiniSat.var(p)) > this.pos(x)) : "chronological inconsistency :(" + this.printLit(p) + " @ " + this.pos(MiniSat.var(p)) + ") is explained by a previous event (" + this.printLit(x) + " @ " + this.pos(x) + ") " + c;
                    this.varBumpActivity(x);
                    this.seen.set(x);
                    if (this.level(x) >= this.trailMarker()) {
                        ++pathC;
                    } else {
                        out_learnt.add(q);
                    }
                }
                ++j;
            }
            while (!this.seen.get(MiniSat.var(this.trail_.get(index--)))) {
            }
            p = this.trail_.get(index + 1);
            confl = this.getConfl(p);
            this.seen.clear(MiniSat.var(p));
        } while (--pathC > 0 || !this.cinfo.get(MiniSat.var(p)).reliable);
        out_learnt.set(0, MiniSat.neg(p));
    }

    private void replaceUnreliableLits(TIntList out_learnt) {
        this.temporary_add_vector_.resetQuick();
        for (int i = 1; i < out_learnt.size(); ++i) {
            int p = out_learnt.get(i);
            if (this.cinfo.get(MiniSat.var(p)).reliable) continue;
            Clause c = this.getConfl(MiniSat.neg(p));
            this.temporary_add_vector_.add(p);
            int at = out_learnt.size() - 1;
            out_learnt.set(i, out_learnt.get(at));
            out_learnt.removeAt(at);
            --i;
            for (int j = 1; j < c.size(); ++j) {
                int q = c._g(j);
                if (this.seen.get(MiniSat.var(q))) continue;
                this.seen.set(MiniSat.var(q));
                out_learnt.add(q);
            }
        }
        while (!this.temporary_add_vector_.isEmpty()) {
            this.seen.clear(MiniSat.var(this.temporary_add_vector_.removeAt(this.temporary_add_vector_.size() - 1)));
        }
    }

    private int getBacktrackLevel(TIntList out_learnt) {
        int out_btlevel;
        if (out_learnt.size() == 1) {
            out_btlevel = this.rootlvl;
        } else {
            int max_i = 1;
            for (int i = 2; i < out_learnt.size(); ++i) {
                if (this.level(MiniSat.var(out_learnt.get(i))) <= this.level(MiniSat.var(out_learnt.get(max_i)))) continue;
                max_i = i;
            }
            int p = out_learnt.get(max_i);
            out_learnt.set(max_i, out_learnt.get(1));
            out_learnt.set(1, p);
            out_btlevel = this.level(MiniSat.var(p));
        }
        return out_btlevel;
    }

    boolean simplify() {
        assert (this.trailMarker() == this.rootlvl);
        if (this.ok_) {
            this.propagate();
        }
        if (!this.ok_ || this.confl != C_Undef) {
            this.ok_ = false;
            return false;
        }
        this.rebuildOrderHeap();
        return true;
    }

    private void rebuildOrderHeap() {
        TIntArrayList vs = new TIntArrayList();
        for (int v = 0; v < this.nVars(); ++v) {
            if (!this.decision.get(v) || this.valueVar(v) != 3) continue;
            vs.add(v);
        }
        this.order_heap.build(vs);
    }

    public void doReduceDB() {
        double extra_lim = this.cla_inc / (double)this.learnts.size();
        this.learnts.sort(Comparator.comparingDouble(c -> c.activity));
        int j = 0;
        for (int i = 0; i < this.learnts.size(); ++i) {
            Clause c2 = this.learnts.get(i);
            if (c2.size() > 2 && !this.locked(c2) && (i < this.learnts.size() / 2 || c2.activity < extra_lim)) {
                this.removeClause(this.learnts.get(i));
                continue;
            }
            this.learnts.set(j++, this.learnts.get(i));
        }
        int n = this.learnts.size();
        this.learnts.subList(j, n).clear();
    }

    boolean withinBudget() {
        return !(this.asynch_interrupt || this.conflict_budget >= 0 && this.conflicts >= this.conflict_budget || this.propagation_budget >= 0 && this.propagations >= this.propagation_budget);
    }

    Clause getConfl(int p) {
        Reason r = this.reason(MiniSat.var(p));
        return r.getConflict();
    }

    Reason reason(int x) {
        return this.vardata.get(x).cr;
    }

    int level(int x) {
        return this.vardata.get(x).level;
    }

    int pos(int x) {
        return this.vardata.get(x).pos;
    }

    boolean locked(Clause c) {
        Clause cr = this.getConfl(c._g(0));
        return this.valueLit(c._g(0)) == 1 && cr != C_Undef && cr == c;
    }

    void removeClause(Clause cr) {
        this.detachClause(cr);
        if (this.locked(cr)) {
            this.vardata.get(MiniSat.var(cr._g(0))).clearReason();
        }
    }

    void claBumpActivity(Clause c) {
        double d;
        c.activity += this.cla_inc;
        if (d > 1.0E20) {
            for (int i = 0; i < this.learnts.size(); ++i) {
                this.learnts.get((int)i).activity *= 1.0E-20;
            }
            this.cla_inc *= 1.0E-20;
        }
    }

    void varBumpActivity(int v) {
        this.varBumpActivity(v, this.var_inc);
    }

    void varBumpActivity(int v, double inc) {
        this.activity.ensureCapacity(this.nVars());
        double a = this.activity.get(v);
        this.activity.setQuick(v, a + inc);
        if (a + inc > 1.0E100) {
            this.activity.transformValues(value -> value * 1.0E-100);
            this.var_inc *= 1.0E-100;
        }
        if (this.order_heap.contains(v)) {
            this.order_heap.decrease(v);
        }
    }

    void varDecayActivity() {
        this.var_inc *= 1.0 / this.var_decay;
    }

    void claDecayActivity() {
        this.cla_inc *= 1.0 / this.clause_decay;
    }

    private static double luby(double y, int x) {
        int size = 1;
        int seq = 0;
        while (size < x + 1) {
            ++seq;
            size = 2 * size + 1;
        }
        while (size - 1 != x) {
            size = size - 1 >> 1;
            --seq;
            x %= size;
        }
        return Math.pow(y, seq);
    }

    public static int makeLiteral(int var, boolean sign) {
        if (var < 0) {
            return 2 * (-var - 1) + (sign ? 0 : 1);
        }
        return 2 * var + (sign ? 1 : 0);
    }

    public static int makeLiteral(int var) {
        return MiniSat.makeLiteral(var, true);
    }

    public static int neg(int l) {
        return l ^ 1;
    }

    public static boolean sgn(int l) {
        return (l & 1) != 0;
    }

    public static int var(int l) {
        return l >> 1;
    }

    static int makeBoolean(boolean b) {
        return b ? 1 : 2;
    }

    public String printLit(int p) {
        ChannelInfo ci = this.cinfo.get(MiniSat.var(p));
        if (ci != null && ci != CI_Null) {
            if (ci.cons_type == 1) {
                int op = ci.val_type * 3 ^ (MiniSat.sgn(p) ? 1 : 0);
                switch (op) {
                    case 0: {
                        return (ci.reliable ? "" : "*") + p + "|" + this.valueLit(p) + "|:" + ci.var + " != " + ci.val + " ";
                    }
                    case 1: {
                        return (ci.reliable ? "" : "*") + p + "|" + this.valueLit(p) + "|:" + ci.var + " == " + ci.val;
                    }
                    case 2: {
                        return (ci.reliable ? "" : "*") + p + "|" + this.valueLit(p) + "|:" + ci.var + " >= " + (ci.val + 1);
                    }
                    case 3: {
                        return (ci.reliable ? "" : "*") + p + "|" + this.valueLit(p) + "|:" + ci.var + " <= " + ci.val;
                    }
                    case 6: {
                        return "*" + p + ":~" + ci.var + " fixed";
                    }
                    case 7: {
                        return "*" + p + ":" + ci.var + " fixed";
                    }
                }
            }
            throw new UnsupportedOperationException();
        }
        return String.valueOf(p);
    }

    private String showReason(Reason r) {
        if (r == null || r == R_Undef) {
            return "no reason";
        }
        StringBuilder st = new StringBuilder();
        switch (r.type) {
            case 0: {
                st.append("clause (");
                Clause cl = (Clause)r;
                for (int i = 1; i < cl.size(); ++i) {
                    if (i > 1) {
                        st.append(" \u2227 ");
                    }
                    st.append(this.printLit(MiniSat.neg(cl._g(i))));
                }
                st.append(")");
                break;
            }
            case 2: {
                st.append("single literal ").append(this.printLit(MiniSat.neg(((Reason.Reason1)r).d1)));
                break;
            }
            case 3: {
                st.append("two literals ").append(this.printLit(MiniSat.neg(((Reason.Reason2)r).d1))).append(" \u2227 ").append(this.printLit(MiniSat.neg(((Reason.Reason2)r).d2)));
            }
        }
        return st.toString();
    }

    private static final class VarData {
        private Reason cr;
        private int level;
        private int pos;

        public VarData(Reason cr, int level, int pos) {
            this.cr = cr;
            this.level = level;
            this.pos = pos;
        }

        private void set(Reason cr, int level, int pos) {
            this.cr = cr;
            this.level = level;
            this.pos = pos;
        }

        private void clearReason() {
            this.cr = R_Undef;
        }
    }

    public static final class ChannelInfo
    implements Channeler {
        private final LitVar var;
        private final int cons_type;
        private final int val_type;
        private final int val;
        private final boolean reliable;

        public ChannelInfo(LitVar var, int ct, int vt, int v) {
            this(var, ct, vt, v, true);
        }

        public ChannelInfo(LitVar var, int ct, int vt, int v, boolean reliable) {
            this.var = var;
            this.cons_type = ct;
            this.val_type = vt;
            this.val = v;
            this.reliable = reliable;
        }

        @Override
        public void channel(boolean sign) {
            if (this.cons_type == 1) {
                this.var.channel(this.val, this.val_type, sign ? 1 : 0);
            }
        }
    }

    private static final class Watcher {
        final Clause clause;
        int blocker;

        Watcher(Clause cr, int l) {
            this.clause = cr;
            this.blocker = l;
        }
    }

    public static interface Channeler {
        public void channel(boolean var1);
    }
}

