/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropXneYHalfReif
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final BoolVar b;

    public PropXneYHalfReif(IntVar x, IntVar y, BoolVar b) {
        super((Variable[])new IntVar[]{x, y, b}, (Priority)PropagatorPriority.LINEAR, false, false);
        this.x = x;
        this.y = y;
        this.b = b;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < 2) {
            return IntEventType.INSTANTIATE.getMask();
        }
        return IntEventType.INCLOW.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.b.isInstantiatedTo(0)) {
            this.setPassive();
        } else if (this.b.isInstantiatedTo(1)) {
            if (this.x.isInstantiated()) {
                this.y.removeValue(this.x.getValue(), this, this.lcg() ? Reason.r(this.x.getValLit(), this.b.getValLit()) : Reason.undef());
                this.setPassive();
            } else if (this.y.isInstantiated()) {
                this.x.removeValue(this.y.getValue(), this, this.lcg() ? Reason.r(this.y.getValLit(), this.b.getValLit()) : Reason.undef());
                this.setPassive();
            }
        } else if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() == this.y.getValue()) {
            this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getValLit(), this.y.getValLit()) : Reason.undef());
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.b.isInstantiatedTo(1)) {
                return ESat.eval(this.x.getValue() != this.y.getValue());
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

