% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{result}
\alias{result}
\title{Wraps a function in an \code{result} monad for later evaluation.}
\usage{
result(.fn, detect_warning = TRUE, fail_on_warning = TRUE)
}
\arguments{
\item{.fn}{function to wrap}

\item{detect_warning}{logical, whether to detect warnings; note \code{result}
cannot capture the outcome value if it catches warnings, so use
\code{detect_warning = TRUE } only if you want to capture the warning
message (e.g., after a side-effect).}

\item{fail_on_warning}{logical, whether to treat warnings as \code{failure}
or \code{success}.}
}
\value{
function that returns a \code{result} object of subclass
\code{success} or \code{failure}
}
\description{
Use \code{result} on functions whose outcomes are not known in advance or not
safe to be examined. The function will not be evaluated until the monad is
explicitly called.
}
\examples{
crashy <- function() stop("Go no further")
safely_call_crashy <- result(crashy)
safely_call_crashy() |> is_failure()

calculate <- function(x, y) x + y
safely_calculate <- result(calculate)
safely_calculate(1, 2) |> value()
}
