% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_hypothesis_tests.R
\name{retrodesign}
\alias{retrodesign}
\title{retrodesign: Calculates Power, Type S, and Type M error}
\usage{
retrodesign(A, s, alpha = 0.05, df = Inf, n.sims = 10000)
}
\arguments{
\item{A}{a numeric or list, an estimate of the true effect size}

\item{s}{a numeric, standard error of the estimate}

\item{alpha}{a numeric, the statistical significance threshold}

\item{df}{a numeric, the degrees of freedom. df=Inf is equivalent
to a normal distribution.}

\item{n.sims}{a numeric, how many times to simulate when calculating Type M
error.}
}
\value{
either a list of length 3 containing the power, type s, and type M
error, or if A is a list, a df that is 4 by length(A), with an effect size
and it's corresponding power, type s, and type m errors in each row.
}
\description{
Calculates Power, Type S, and Type M error and returns them in a list or
df, depending on whether a single true effect size or range is provided.
retro_design() is faster as it uses the closed form solution from Lu et al.
(2018), but this function can be used for t distributions, whereas
retro_design() cannot. Function originally provided in Gelman and
Carlin (2014), modified with permission.
}
\examples{
retrodesign(1,3.28)
retrodesign(list(.2,2,20),8.1)
retrodesign(.5,1,df=10)
}
