% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toml_serialization.R
\name{to_toml}
\alias{to_toml}
\title{Convert R \code{list()} into toml-compatible format.}
\usage{
to_toml(..., .str_as_literal = TRUE, .format_int = "\%d", .format_dbl = "\%g")
}
\arguments{
\item{...}{A list from which toml is constructed.
Supports nesting and tidy evaluation.}

\item{.str_as_literal}{Logical indicating whether to treat
strings as literal (single quotes no escapes) or
basic (escaping some sequences) ones. Default is \code{TRUE}.}

\item{.format_int, .format_dbl}{Character scalar describing
number formatting. Compatible with \code{sprintf}.}
}
\value{
A character vector, each element corresponds to
one line of the resulting output.
}
\description{
\code{\link[=to_toml]{to_toml()}} can be used to build \code{Cargo.toml}.
The cargo manifest can be represented in terms of
R objects, allowing limited validation and syntax verification.
This function converts manifests written using R objects into
toml representation, applying basic formatting,
which is ideal for generating cargo
manifests at runtime.
}
\examples{
# Produces [workspace] with no children
to_toml(workspace = NULL)

to_toml(patch.crates_io = list(`extendr-api` = list(git = "git-ref")))

# Single-element arrays are distinguished from scalars
# using explicitly set `dim`
to_toml(lib = list(`crate-type` = array("cdylib", 1)))
}
