% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fc_get_user}
\alias{fc_get_user}
\alias{fc_get_user_stations}
\alias{fc_get_station}
\alias{fc_get_data}
\alias{fc_get_data_range}
\title{Read user information}
\usage{
fc_get_user(...)

fc_get_user_stations(...)

fc_get_station(station_id = NULL, ...)

fc_get_data(station_id = NULL, ...)

fc_get_data_range(
  station_id = NULL,
  data_group = c("raw", "hourly", "daily", "monthly"),
  from = NULL,
  to = NULL,
  ...
)
}
\arguments{
\item{...}{additional arguments passed to \code{\link[=fc_request]{fc_request()}}}

\item{station_id}{station id to query}

\item{data_group}{how to group data}

\item{from}{time in unix timestamps since UTC,
e.g. via as.integer(as.POSIXct(Sys.time()))}

\item{to}{time in unix timestamps since UTC
as.integer(as.POSIXct(Sys.time()))}
}
\value{
a list with user information.

a list with user stations information.

a list with station details.

a list with station metadata.

a list with station data.
}
\description{
Read user information

List of user devices.

Get station information

Get  min and max date of device data availability

Getdata between specified time periods.
}
\examples{
\dontrun{
  fc_get_user()
}
\dontrun{
stations <- fc_get_user_stations()
stations
}
\dontrun{
stations <- fc_get_user_stations()
fc_get_station(stations[[1]]$station_name)
}
\dontrun{
stations <- fc_get_user_stations()
fc_get_data(stations[[1]]$station_name)
}
\dontrun{
stations <- fc_get_user_stations()
fc_get_data_range(
  station_id = stations[[1]]$station_name,
  data_group = "raw",
  from = as.integer(as.POSIXct(Sys.time() - 60*60*24)),
  to =  as.integer(as.POSIXct(Sys.time())))
}
}
