% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_orders.R
\name{list_orders}
\alias{list_orders}
\title{Get List of All Orders for the User}
\usage{
list_orders(
  api.key,
  secret,
  passphrase,
  product_id = "BTC-USD",
  status = "open"
)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}

\item{product_id}{Optional character value for the currency pair. The default is \code{"BTC-USD"}. This param is case insensitive and must be one of the valid currency-pair. The list of valid currency-pairs can be fetched using \code{\link{public_info}}.}

\item{status}{Optional character value. Limit list of orders to either of `open`, `pending`, or `active` statuses. Passing `all` returns orders of all statuses.}
}
\value{
Dataframe with all orders for a given status for that currency.
}
\description{
This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The function will return all open orders by default for Bitcoin This is an extension of \code{\link{open_orders}}.
}
\examples{
\dontrun{
list_orders(api.key = your_key,
secret = your_api_secret,
passphrase = your_api_pass)

list_orders(api.key=your_api_key,secret=your_secret,
passphrase=your_passphrase,
product_id="BTC-EUR",status="active")
}

}
