% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemannian-metric.R
\name{RiemannianMetric}
\alias{RiemannianMetric}
\title{Abstract Class for Riemannian Metrics}
\description{
An \link[R6:R6Class]{R6::R6Class} object implementing the base
\code{\link{RiemannianMetric}} class. This is an abstract class for Riemannian and
pseudo-Riemannian metrics which are the associated Levi-Civita connection
on the tangent bundle.
}
\examples{

## ------------------------------------------------
## Method `RiemannianMetric$metric_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$metric_matrix()
}

## ------------------------------------------------
## Method `RiemannianMetric$cometric_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$cometric_matrix()
}

## ------------------------------------------------
## Method `RiemannianMetric$inner_product_derivative_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$inner_product_derivative_matrix()
}

## ------------------------------------------------
## Method `RiemannianMetric$inner_product`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$inner_product(diag(0, 3), diag(1, 3), base_point = diag(1, 3))
}

## ------------------------------------------------
## Method `RiemannianMetric$inner_coproduct`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$inner_coproduct(diag(0, 3), diag(1, 3), base_point = diag(1, 3))
}

## ------------------------------------------------
## Method `RiemannianMetric$hamiltonian`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$hamiltonian()
}

## ------------------------------------------------
## Method `RiemannianMetric$normalize`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$normalize(diag(2, 3), diag(1, 3))
}

## ------------------------------------------------
## Method `RiemannianMetric$random_unit_tangent_vec`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$random_unit_tangent_vec(diag(1, 3))
}

## ------------------------------------------------
## Method `RiemannianMetric$dist`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$dist(diag(1, 3), diag(1, 3))
}

## ------------------------------------------------
## Method `RiemannianMetric$dist_broadcast`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$dist(diag(1, 3), diag(1, 3))
}
}
\author{
Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Connection]{rgeomstats::Connection}} -> \code{RiemannianMetric}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{signature}}{An integer vector specifying the signature of the
metric.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RiemannianMetric-new}{\code{RiemannianMetric$new()}}
\item \href{#method-RiemannianMetric-metric_matrix}{\code{RiemannianMetric$metric_matrix()}}
\item \href{#method-RiemannianMetric-cometric_matrix}{\code{RiemannianMetric$cometric_matrix()}}
\item \href{#method-RiemannianMetric-inner_product_derivative_matrix}{\code{RiemannianMetric$inner_product_derivative_matrix()}}
\item \href{#method-RiemannianMetric-inner_product}{\code{RiemannianMetric$inner_product()}}
\item \href{#method-RiemannianMetric-inner_coproduct}{\code{RiemannianMetric$inner_coproduct()}}
\item \href{#method-RiemannianMetric-hamiltonian}{\code{RiemannianMetric$hamiltonian()}}
\item \href{#method-RiemannianMetric-squared_norm}{\code{RiemannianMetric$squared_norm()}}
\item \href{#method-RiemannianMetric-norm}{\code{RiemannianMetric$norm()}}
\item \href{#method-RiemannianMetric-normalize}{\code{RiemannianMetric$normalize()}}
\item \href{#method-RiemannianMetric-random_unit_tangent_vec}{\code{RiemannianMetric$random_unit_tangent_vec()}}
\item \href{#method-RiemannianMetric-squared_dist}{\code{RiemannianMetric$squared_dist()}}
\item \href{#method-RiemannianMetric-dist}{\code{RiemannianMetric$dist()}}
\item \href{#method-RiemannianMetric-dist_broadcast}{\code{RiemannianMetric$dist_broadcast()}}
\item \href{#method-RiemannianMetric-dist_pairwise}{\code{RiemannianMetric$dist_pairwise()}}
\item \href{#method-RiemannianMetric-diameter}{\code{RiemannianMetric$diameter()}}
\item \href{#method-RiemannianMetric-closest_neighbor_index}{\code{RiemannianMetric$closest_neighbor_index()}}
\item \href{#method-RiemannianMetric-normal_basis}{\code{RiemannianMetric$normal_basis()}}
\item \href{#method-RiemannianMetric-sectional_curvature}{\code{RiemannianMetric$sectional_curvature()}}
\item \href{#method-RiemannianMetric-clone}{\code{RiemannianMetric$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="christoffels"><a href='../../rgeomstats/html/Connection.html#method-Connection-christoffels'><code>rgeomstats::Connection$christoffels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="curvature"><a href='../../rgeomstats/html/Connection.html#method-Connection-curvature'><code>rgeomstats::Connection$curvature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="curvature_derivative"><a href='../../rgeomstats/html/Connection.html#method-Connection-curvature_derivative'><code>rgeomstats::Connection$curvature_derivative()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="directional_curvature"><a href='../../rgeomstats/html/Connection.html#method-Connection-directional_curvature'><code>rgeomstats::Connection$directional_curvature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="directional_curvature_derivative"><a href='../../rgeomstats/html/Connection.html#method-Connection-directional_curvature_derivative'><code>rgeomstats::Connection$directional_curvature_derivative()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="exp"><a href='../../rgeomstats/html/Connection.html#method-Connection-exp'><code>rgeomstats::Connection$exp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="geodesic"><a href='../../rgeomstats/html/Connection.html#method-Connection-geodesic'><code>rgeomstats::Connection$geodesic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="geodesic_equation"><a href='../../rgeomstats/html/Connection.html#method-Connection-geodesic_equation'><code>rgeomstats::Connection$geodesic_equation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="injectivity_radius"><a href='../../rgeomstats/html/Connection.html#method-Connection-injectivity_radius'><code>rgeomstats::Connection$injectivity_radius()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="ladder_parallel_transport"><a href='../../rgeomstats/html/Connection.html#method-Connection-ladder_parallel_transport'><code>rgeomstats::Connection$ladder_parallel_transport()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="log"><a href='../../rgeomstats/html/Connection.html#method-Connection-log'><code>rgeomstats::Connection$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Connection" data-id="parallel_transport"><a href='../../rgeomstats/html/Connection.html#method-Connection-parallel_transport'><code>rgeomstats::Connection$parallel_transport()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-new"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{RiemannianMetric}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$new(
  dim,
  shape = NULL,
  signature = NULL,
  default_coords_type = "intrinsic",
  py_cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{signature}}{An integer vector specifying the signature of the
metric. Defaults to \code{c(dim, 0L)}.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrensic} or \code{intrinsic}. Defaults to \code{intrinsic}.}

\item{\code{py_cls}}{A Python object of class \code{RiemannianMetric}. Defaults to
\code{NULL} in which case it is instantiated on the fly using the other
input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{RiemannianMetric}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-metric_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-metric_matrix}{}}}
\subsection{Method \code{metric_matrix()}}{
Metric matrix at the tangent space at a base point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$metric_matrix(base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \verb{dim x dim} storing the inner-product
matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$metric_matrix()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-cometric_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-cometric_matrix}{}}}
\subsection{Method \code{cometric_matrix()}}{
Inner co-product matrix at the cotangent space at a base
point. This represents the cometric matrix, i.e. the inverse of the
metric matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$cometric_matrix(base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \verb{dim x dim} storing the inverse of the
inner-product matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$cometric_matrix()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-inner_product_derivative_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-inner_product_derivative_matrix}{}}}
\subsection{Method \code{inner_product_derivative_matrix()}}{
Compute derivative of the inner prod matrix at base point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$inner_product_derivative_matrix(base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \verb{dim x dim} storing the derivative of
the inverse of the inner-product matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$inner_product_derivative_matrix()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-inner_product"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-inner_product}{}}}
\subsection{Method \code{inner_product()}}{
Inner product between two tangent vectors at a base point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$inner_product(tangent_vec_a, tangent_vec_b, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{A numeric array of shape \code{dim} specifying a tangent
vector at base point.}

\item{\code{tangent_vec_b}}{A numeric array of shape \code{dim} specifying a tangent
vector at base point.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scalar value representing the inner product between the two
input tangent vectors at the input base point.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$inner_product(diag(0, 3), diag(1, 3), base_point = diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-inner_coproduct"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-inner_coproduct}{}}}
\subsection{Method \code{inner_coproduct()}}{
Computes inner coproduct between two cotangent vectors at
base point. This is the inner product associated to the cometric
matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$inner_coproduct(
  cotangent_vec_a,
  cotangent_vec_b,
  base_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cotangent_vec_a}}{A numeric array of shape \code{dim} specifying a
cotangent vector at base point.}

\item{\code{cotangent_vec_b}}{A numeric array of shape \code{dim} specifying a
cotangent vector at base point.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scalar value representing the inner coproduct between the two
input cotangent vectors at the input base point.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$inner_coproduct(diag(0, 3), diag(1, 3), base_point = diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-hamiltonian"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-hamiltonian}{}}}
\subsection{Method \code{hamiltonian()}}{
Computes the Hamiltonian energy associated to the cometric.
The Hamiltonian at state \eqn{(q, p)} is defined by \deqn{H(q, p) =
  \frac{1}{2} \langle p, p \rangle_q,} where \eqn{\langle \cdot, \cdot
  \rangle_q} is the cometric at \eqn{q}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$hamiltonian(state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{A list with two components: (i) a numeric array of shape
\code{dim} specifying the \emph{position} which is a point on the manifold and
(ii) a numeric array of shape \code{dim} specifying the \emph{momentum} which is
a cotangent vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value representing the Hamiltonian energy at \code{state}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$hamiltonian()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-squared_norm"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-squared_norm}{}}}
\subsection{Method \code{squared_norm()}}{
Computes the square of the norm of a vector. Squared norm of
a vector associated to the inner product at the tangent space at a base
point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$squared_norm(vector, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vector}}{A numeric array of shape \code{dim} specifying a vector.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value representing the squared norm of the input
vector.

if (reticulate::py_module_available("geomstats")) {
mt <- SPDMetricLogEuclidean$new(n = 3)
mt$squared_norm(diag(0, 3), diag(1, 3))
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-norm"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-norm}{}}}
\subsection{Method \code{norm()}}{
Computes the norm of a vector associated to the inner
product at the tangent space at a base point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$norm(vector, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vector}}{A numeric array of shape \code{dim} specifying a vector.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This only works for positive-definite Riemannian metrics and
inner products.
}

\subsection{Returns}{
A numeric value representing the norm of the input vector.

if (reticulate::py_module_available("geomstats")) {
mt <- SPDMetricLogEuclidean$new(n = 3)
mt$norm(diag(0, 3), diag(1, 3))
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-normalize"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-normalize}{}}}
\subsection{Method \code{normalize()}}{
Normalizes a tangent vector at a given point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$normalize(vector, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vector}}{A numeric array of shape \code{dim} specifying a vector.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{dim} storing the normalized version of
the input tangent vector.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$normalize(diag(2, 3), diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-random_unit_tangent_vec"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-random_unit_tangent_vec}{}}}
\subsection{Method \code{random_unit_tangent_vec()}}{
Generates a random unit tangent vector at a given point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$random_unit_tangent_vec(base_point = NULL, n_vectors = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}

\item{\code{n_vectors}}{An integer value specifying the number of vectors to be
generated at \code{base_point}. For vectorization purposes, \code{n_vectors} can
be greater than 1 \emph{iff} \code{base_point} corresponds to a single point.
Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{c(n_vectors, dim)} storing random unit
tangent vectors at \code{base_point}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  # mt <- SPDMetricLogEuclidean$new(n = 3)
  # mt$random_unit_tangent_vec(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-squared_dist"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-squared_dist}{}}}
\subsection{Method \code{squared_dist()}}{
Squared geodesic distance between two points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$squared_dist(point_a, point_b, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_a}}{A numeric array of shape \code{dim} on the manifold.}

\item{\code{point_b}}{A numeric array of shape \code{dim} on the manifold.}

\item{\code{...}}{Extra parameters to be passed to the \verb{$log()} method of the
parent \code{\link{Connection}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value storing the squared geodesic distance between the
two input points.

if (reticulate::py_module_available("geomstats")) {
mt <- SPDMetricLogEuclidean$new(n = 3)
mt$squared_dist(diag(1, 3), diag(1, 3))
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-dist"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-dist}{}}}
\subsection{Method \code{dist()}}{
Geodesic distance between two points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$dist(point_a, point_b, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_a}}{A numeric array of shape \code{dim} on the manifold.}

\item{\code{point_b}}{A numeric array of shape \code{dim} on the manifold.}

\item{\code{...}}{Extra parameters to be passed to the \verb{$log()} method of the
parent \code{\link{Connection}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
It only works for positive definite Riemannian metrics.
}

\subsection{Returns}{
A numeric value storing the geodesic distance between the two
input points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$dist(diag(1, 3), diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-dist_broadcast"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-dist_broadcast}{}}}
\subsection{Method \code{dist_broadcast()}}{
Computes the geodesic distance between points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$dist_broadcast(points_a, points_b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points_a}}{A numeric array of shape \code{c(n_samples_a, dim)} specifying
a set of points on the manifold.}

\item{\code{points_b}}{A numeric array of shape \code{c(n_samples_b, dim)} specifying
a set of points on the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If \code{n_samples_a == n_samples_b} then \code{dist} is the element-wise
distance result of a point in \code{points_a} with the point from \code{points_b}
of the same index. If \code{n_samples_a != n_samples_b} then \code{dist} is the
result of applying geodesic distance for each point from \code{points_a} to
all points from \code{points_b}.
}

\subsection{Returns}{
A numeric array of shape \code{c(n_samples_a, dim)} if \code{n_samples_a == n_samples_b} or of shape \code{c(n_samples_a, n_samples_b, dim)} if
\code{n_samples_a != n_samples_b} storing the geodesic distance between
points in set A and points in set B.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  mt <- SPDMetricLogEuclidean$new(n = 3)
  mt$dist(diag(1, 3), diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-dist_pairwise"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-dist_pairwise}{}}}
\subsection{Method \code{dist_pairwise()}}{
Computes the pairwise distance between points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$dist_pairwise(points, n_jobs = 1, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points}}{A numeric array of shape \code{c(n_samples, dim)} specifying a
set of points on the manifold.}

\item{\code{n_jobs}}{An integer value specifying the number of cores for
parallel computation. Defaults to \code{1L}.}

\item{\code{...}}{Extra parameters to be passed tothe  \code{joblib.Parallel} Python
class. See \href{https://joblib.readthedocs.io/en/latest/}{joblib documentation} for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric matrix of shape \code{c(n_samples, n_samples)} storing the
pairwise geodesic distances between all the points.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-diameter"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-diameter}{}}}
\subsection{Method \code{diameter()}}{
Computes the diameter of set of points on a manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$diameter(points)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points}}{A numeric array of shape \code{c(n_samples, dim)} specifying a
set of points on the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The diameter is the maximum over all pairwise distances.
}

\subsection{Returns}{
A numeric value representing the largest distance between any two
points in the input set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-closest_neighbor_index"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-closest_neighbor_index}{}}}
\subsection{Method \code{closest_neighbor_index()}}{
Finds the closest neighbor to a point among a set of
neighbors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$closest_neighbor_index(point, neighbors)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \code{dim} specifying a point on the
manifold.}

\item{\code{neighbors}}{A numeric array of shape \code{c(n_neighbors, dim)}
specifying a set of neighboring points for the input \code{point}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer value representing the index of the neighbor in
\code{neighbors} that is closest to \code{point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-normal_basis"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-normal_basis}{}}}
\subsection{Method \code{normal_basis()}}{
Normalizes the basis with respect to the metric. This
corresponds to a renormalization of each basis vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$normal_basis(basis, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{basis}}{A numeric array of shape \code{c(dim, dim)} specifying a basis.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{c(dim, n, n)} storing the normal basis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-sectional_curvature"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-sectional_curvature}{}}}
\subsection{Method \code{sectional_curvature()}}{
Computes the sectional curvature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$sectional_curvature(
  tangent_vec_a,
  tangent_vec_b,
  base_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{A numeric array of shape \code{c(n, n)} specifying a
tangent vector at \code{base_point}.}

\item{\code{tangent_vec_b}}{A numeric array of shape \code{c(n, n)} specifying a
tangent vector at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a point on
the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For two orthonormal tangent vectors \eqn{x} and \eqn{y} at a
base point, the sectional curvature is defined by \deqn{\langle R(x,
  y)x, y \rangle = \langle R_x(y), y \rangle.} For non-orthonormal
vectors, it is \deqn{\langle R(x, y)x, y \rangle / \\|x \wedge y\\|^2.}
See also https://en.wikipedia.org/wiki/Sectional_curvature.
}

\subsection{Returns}{
A numeric value representing the sectional curvature at
\code{base_point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RiemannianMetric-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RiemannianMetric-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RiemannianMetric$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
