% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spd-matrices.R
\name{SPDMatrices}
\alias{SPDMatrices}
\title{Class for the Manifold of Symmetric Positive Definite Matrices}
\description{
Class for the manifold of symmetric positive definite (SPD)
matrices.
}
\examples{

## ------------------------------------------------
## Method `SPDMatrices$new`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3
}

## ------------------------------------------------
## Method `SPDMatrices$cholesky_factor`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$cholesky_factor(A)
}

## ------------------------------------------------
## Method `SPDMatrices$differential_cholesky_factor`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_cholesky_factor(diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$expm`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$expm(diag(-1, 3))
}

## ------------------------------------------------
## Method `SPDMatrices$differential_exp`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_exp(diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$inverse_differential_exp`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_exp(diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$logm`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$logm(diag(1, 3))
}

## ------------------------------------------------
## Method `SPDMatrices$differential_log`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_log(diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$inverse_differential_log`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_log(diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$powerm`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$powerm(diag(1, 3), 2)
}

## ------------------------------------------------
## Method `SPDMatrices$differential_power`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_power(2, diag(1, 3), A)
}

## ------------------------------------------------
## Method `SPDMatrices$inverse_differential_power`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_power(2, diag(1, 3), A)
}
}
\seealso{
Other symmetric positive definite matrix classes: 
\code{\link{SPDMatrix}()}
}
\author{
Yann Thanwerdas
}
\concept{symmetric positive definite matrix classes}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:OpenSet]{rgeomstats::OpenSet}} -> \code{SPDMatrices}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n}}{An integer value specifying the number of rows and columns of the
matrices.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SPDMatrices-new}{\code{SPDMatrices$new()}}
\item \href{#method-SPDMatrices-cholesky_factor}{\code{SPDMatrices$cholesky_factor()}}
\item \href{#method-SPDMatrices-differential_cholesky_factor}{\code{SPDMatrices$differential_cholesky_factor()}}
\item \href{#method-SPDMatrices-expm}{\code{SPDMatrices$expm()}}
\item \href{#method-SPDMatrices-differential_exp}{\code{SPDMatrices$differential_exp()}}
\item \href{#method-SPDMatrices-inverse_differential_exp}{\code{SPDMatrices$inverse_differential_exp()}}
\item \href{#method-SPDMatrices-logm}{\code{SPDMatrices$logm()}}
\item \href{#method-SPDMatrices-differential_log}{\code{SPDMatrices$differential_log()}}
\item \href{#method-SPDMatrices-inverse_differential_log}{\code{SPDMatrices$inverse_differential_log()}}
\item \href{#method-SPDMatrices-powerm}{\code{SPDMatrices$powerm()}}
\item \href{#method-SPDMatrices-differential_power}{\code{SPDMatrices$differential_power()}}
\item \href{#method-SPDMatrices-inverse_differential_power}{\code{SPDMatrices$inverse_differential_power()}}
\item \href{#method-SPDMatrices-clone}{\code{SPDMatrices$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="OpenSet" data-id="projection"><a href='../../rgeomstats/html/OpenSet.html#method-OpenSet-projection'><code>rgeomstats::OpenSet$projection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-new"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SPDMatrices}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$new(n, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{An integer value specifying the number of rows and columns of the
matrices.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{OpenSet}} and \code{\link{Manifold}} classes.}

\item{\code{py_cls}}{A Python object of class \code{SPDMatrices}. Defaults to \code{NULL}
in which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SPDMatrices}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-cholesky_factor"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-cholesky_factor}{}}}
\subsection{Method \code{cholesky_factor()}}{
Computes Cholesky factor for a symmetric positive definite
matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$cholesky_factor(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the corresponding
Cholesky factors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$cholesky_factor(A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-differential_cholesky_factor"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-differential_cholesky_factor}{}}}
\subsection{Method \code{differential_cholesky_factor()}}{
Computes the differential of the Cholesky factor map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$differential_cholesky_factor(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} storing
the differentials of the corresponding Cholesky factor maps.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_cholesky_factor(diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-expm"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-expm}{}}}
\subsection{Method \code{expm()}}{
Computes the matrix exponential for a symmetric matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$expm(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the corresponding
matrix exponentials.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$expm(diag(-1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-differential_exp"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-differential_exp}{}}}
\subsection{Method \code{differential_exp()}}{
Computes the differential of the matrix exponential.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$differential_exp(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the differentials of matrix exponential at corresponding base points
applied to corresponding tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_exp(diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-inverse_differential_exp"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-inverse_differential_exp}{}}}
\subsection{Method \code{inverse_differential_exp()}}{
Computes the inverse of the differential of the matrix
exponential.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$inverse_differential_exp(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the inverse of the differentials of matrix exponential at corresponding
base points applied to corresponding tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_exp(diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-logm"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-logm}{}}}
\subsection{Method \code{logm()}}{
Computes the matrix logarithm of an SPD matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$logm(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the logarithms of the
input SPD matrices.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$logm(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-differential_log"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-differential_log}{}}}
\subsection{Method \code{differential_log()}}{
Computes the differential of the matrix logarithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$differential_log(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the differentials of matrix logarithm at corresponding base points
applied to corresponding tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_log(diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-inverse_differential_log"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-inverse_differential_log}{}}}
\subsection{Method \code{inverse_differential_log()}}{
Computes the inverse of the differential of the matrix
logarithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$inverse_differential_log(tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the inverse of the differentials of matrix logarithm at corresponding
base points applied to corresponding tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_log(diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-powerm"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-powerm}{}}}
\subsection{Method \code{powerm()}}{
Computes the matrix power of an SPD matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$powerm(mat, power)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices.}

\item{\code{power}}{A numeric value or vector specifying the desired power(s).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape as \code{mat} storing the
corresponding matrix powers computed as: \deqn{A^p = \exp(p \log(A)).}
If \code{power} is a vector, a list of such arrays is returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3$powerm(diag(1, 3), 2)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-differential_power"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-differential_power}{}}}
\subsection{Method \code{differential_power()}}{
Computes the differential of the matrix power function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$differential_power(power, tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{power}}{An integer value specifying the desired power.}

\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the differential of the power function \deqn{A^p = \exp(p \log(A))} at
corresponding base points applied to corresponding tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$differential_power(2, diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-inverse_differential_power"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-inverse_differential_power}{}}}
\subsection{Method \code{inverse_differential_power()}}{
Computes the inverse of the differential of the matrix power
function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$inverse_differential_power(power, tangent_vec, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{power}}{An integer value specifying the desired power.}

\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more symmetric matrices at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more SPD matrices specifying base points for the input
tangent vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times]} storing
the inverse of the differential of the power function \deqn{A^p =
  \exp(p \log(A))} at corresponding base points applied to corresponding
tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  V <- cbind(
    c(sqrt(2) / 2, -sqrt(2) / 2, 0),
    c(sqrt(2) / 2, sqrt(2) / 2, 0),
    c(0, 0, 1)
  )
  A <- V \%*\% diag(1:3) \%*\% t(V)
  spd3$inverse_differential_power(2, diag(1, 3), A)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SPDMatrices-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SPDMatrices-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SPDMatrices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
