% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-orthogonal.R
\name{SpecialOrthogonal2Vectors}
\alias{SpecialOrthogonal2Vectors}
\title{Abstract Class for the 2D Special Orthogonal Group in Vector Representation}
\description{
Class for the special orthogonal group \eqn{\mathrm{SO}(2)} in
vector form, i.e. the Lie group of planar rotations. This class is
specific to the vector representation of rotations. For the matrix
representation, use the \code{\link{SpecialOrthogonal}} class and set \code{n = 2}.
}
\examples{

## ------------------------------------------------
## Method `SpecialOrthogonal2Vectors$rotation_vector_from_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$rotation_vector_from_matrix(diag(1, 2))
}

## ------------------------------------------------
## Method `SpecialOrthogonal2Vectors$matrix_from_rotation_vector`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$matrix_from_rotation_vector(array(0))
}
}
\seealso{
Other special orthogonal classes: 
\code{\link{SpecialOrthogonal3Vectors}},
\code{\link{SpecialOrthogonalMatrices}},
\code{\link{SpecialOrthogonal}()}
}
\author{
Nicolas Guigui and Nina Miolane
}
\concept{special orthogonal classes}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:LieGroup]{rgeomstats::LieGroup}} -> \code{\link[rgeomstats:SpecialOrthogonalVectors]{rgeomstats::SpecialOrthogonalVectors}} -> \code{SpecialOrthogonal2Vectors}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpecialOrthogonal2Vectors-new}{\code{SpecialOrthogonal2Vectors$new()}}
\item \href{#method-SpecialOrthogonal2Vectors-rotation_vector_from_matrix}{\code{SpecialOrthogonal2Vectors$rotation_vector_from_matrix()}}
\item \href{#method-SpecialOrthogonal2Vectors-matrix_from_rotation_vector}{\code{SpecialOrthogonal2Vectors$matrix_from_rotation_vector()}}
\item \href{#method-SpecialOrthogonal2Vectors-random_uniform}{\code{SpecialOrthogonal2Vectors$random_uniform()}}
\item \href{#method-SpecialOrthogonal2Vectors-clone}{\code{SpecialOrthogonal2Vectors$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="add_metric"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-add_metric'><code>rgeomstats::LieGroup$add_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="compose"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-compose'><code>rgeomstats::LieGroup$compose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp'><code>rgeomstats::LieGroup$exp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_from_identity'><code>rgeomstats::LieGroup$exp_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_not_from_identity'><code>rgeomstats::LieGroup$exp_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="get_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-get_identity'><code>rgeomstats::LieGroup$get_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="inverse"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-inverse'><code>rgeomstats::LieGroup$inverse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="jacobian_translation"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-jacobian_translation'><code>rgeomstats::LieGroup$jacobian_translation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="lie_bracket"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-lie_bracket'><code>rgeomstats::LieGroup$lie_bracket()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log'><code>rgeomstats::LieGroup$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_from_identity'><code>rgeomstats::LieGroup$log_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_not_from_identity'><code>rgeomstats::LieGroup$log_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="tangent_translation_map"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-tangent_translation_map'><code>rgeomstats::LieGroup$tangent_translation_map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="projection"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-projection'><code>rgeomstats::SpecialOrthogonalVectors$projection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="regularize_tangent_vec"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-regularize_tangent_vec'><code>rgeomstats::SpecialOrthogonalVectors$regularize_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="regularize_tangent_vec_at_identity"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-regularize_tangent_vec_at_identity'><code>rgeomstats::SpecialOrthogonalVectors$regularize_tangent_vec_at_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="skew_matrix_from_vector"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-skew_matrix_from_vector'><code>rgeomstats::SpecialOrthogonalVectors$skew_matrix_from_vector()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="vector_from_skew_matrix"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-vector_from_skew_matrix'><code>rgeomstats::SpecialOrthogonalVectors$vector_from_skew_matrix()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal2Vectors-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal2Vectors-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SpecialOrthogonal2Vectors}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal2Vectors$new(epsilon = 0, py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epsilon}}{A numeric value specifying the precision to use for
calculations involving potential division by 0 in rotations. Defaults to
\code{0}.}

\item{\code{py_cls}}{A Python object of class \code{SpecialOrthogonal2Vectors}.
Defaults to \code{NULL} in which case it is instantiated on the fly using
the other input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SpecialOrthogonal2Vectors}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal2Vectors-rotation_vector_from_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal2Vectors-rotation_vector_from_matrix}{}}}
\subsection{Method \code{rotation_vector_from_matrix()}}{
Converts rotation matrix (in 2D) to rotation vector
(axis-angle) getting the angle through the \code{atan2()} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal2Vectors$rotation_vector_from_matrix(rot_mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_mat}}{A numeric array of shape \eqn{[\dots \times 2 \times 2]}
specifying one or more 2D rotation matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 1]} storing the
corresponding axis-angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$rotation_vector_from_matrix(diag(1, 2))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal2Vectors-matrix_from_rotation_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal2Vectors-matrix_from_rotation_vector}{}}}
\subsection{Method \code{matrix_from_rotation_vector()}}{
Convert a 2D rotation from vector to matrix representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal2Vectors$matrix_from_rotation_vector(rot_vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_vec}}{A numeric array of shape \eqn{... \times 1} specifying one
or more 2D rotations in vector representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{... \times 2 \times 2} storing the
corresponding 2D rotation matrices.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$matrix_from_rotation_vector(array(0))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal2Vectors-random_uniform"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal2Vectors-random_uniform}{}}}
\subsection{Method \code{random_uniform()}}{
Samples in \eqn{\mathrm{SO}(2)} from a uniform distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal2Vectors$random_uniform(n_samples = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_samples}}{An integer value specifying the sample size. Defaults to
\code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{... \times 1} storing a sample of
2D rotations in axis-angle representation uniformly sampled in
\eqn{\mathrm{SO}(2)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal2Vectors-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal2Vectors-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal2Vectors$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
