% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgexf.R
\name{edge.list}
\alias{edge.list}
\title{Decompose an edge list}
\usage{
edge.list(x)
}
\arguments{
\item{x}{A matrix or data frame structured as a list of edges}
}
\value{
A list containing two data frames.
}
\description{
Generates two data frames (nodes and edges) from a list of edges
}
\details{
\code{edge.list} transforms the input into a two-elements list containing a
dataframe of nodes (with columns \dQuote{id} and \dQuote{label}) and a
dataframe of edges. The last one is numeric (with columns \dQuote{source}
and \dQuote{target}) and based on auto-generated nodes' ids.
}
\examples{

  edgelist <- matrix(
    c("matthew","john",
      "max","stephen",
      "matthew","stephen"),
    byrow=TRUE, ncol=2)
  
  edge.list(edgelist)

}
\author{
George Vega Yon

Jorge Fabrega Lacoa
}
\keyword{manip}
