% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_demo.R
\name{dp_demo}
\alias{dp_demo}
\title{Examples of using the cry and rgl packages together.}
\usage{
dp_demo(file = NULL, reso = 1.2, ews.r = 40, zoom = 0.5, xrd = FALSE)
}
\arguments{
\item{file}{Optional file in CIF formats.}

\item{reso}{A real number. The highest data resolution, in angstroms.  If the
default value takes a long time to process displaying due to the large number
of lattice points, you can expect to improve performance by increasing the
value.}

\item{ews.r}{Ewald sphere radius in angstrom^-1.}

\item{zoom}{A positive value indicating the current scene magnification.}

\item{xrd}{A logical value indicating whether to create an X-ray diffraction
pattern simulation result file.}
}
\value{
An integer the device number of the currently window.
}
\description{
Read a file in CIF formats, set and the parameters, calculates them, draws
the reciprocal lattice map with a cell widget.
}
\details{
If no file argument is provided, and \code{cry_demo()} has been opened without
paired \code{dp_demo()}, the CIF parameters of already opened \code{cry_demo()} will be
used.

Interactive rotation, zooming, and panning of structures are possible using
the 3D graphics library \code{rgl}.  When the drag originates near the window
edge (within 5\%), perform a Z-axis rotation.

This function also performs powder diffraction simulation and saves the
results to a file in the working directory.  Currently, it doesn't account
for atomic ionization and uses standard atomic scattering factors.
}
\examples{
dp_demo()
dp_demo(system.file("orthorhombic_p.cif", package = "rgl.cry"))
dp_demo(system.file("orthorhombic_p.cif", package = "rgl.cry"), res = 2.0)

\donttest{
if (interactive()) {
 dp_demo(file, zoom = 0.5)
 dp_demo("https://www.crystallography.net/cod/foo.cif")
}
}
}
