% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{auto_test_r}
\alias{auto_test_r}
\title{Watch and automatically run R tests}
\usage{
auto_test_r(reporter = NULL, filter = NULL, hash = TRUE)
}
\arguments{
\item{reporter}{\code{{testthat}} reporter to use.
If NULL, will use \code{testthat::default_reporter()} for tests when running all tests
and \code{testthat::default_compact_reporter()} for single file tests.
See \href{https://testthat.r-lib.org/reference/Reporter.html}{\code{{testthat}} reporters} for more details.}

\item{filter}{filter passed to \code{testthat::test_dir()}. If not NULL, only tests with file names matching this regular expression will be executed.
Matching is performed on the file name after it's stripped of "test-" and ".R".
Does not affect the case when a test file is changed. In this case, this test file is rerun.}

\item{hash}{Logical. Whether to use file hashing to detect changes. Default is TRUE.
If FALSE, file modification times are used instead.}
}
\value{
None. This function is called for side effects.
}
\description{
Watches R files in the \code{app} directory and \code{tests/testthat} directory for changes.
When code files in \code{app} change, all tests are rerun. When test files change,
only the changed test file is rerun.
}
\examples{
if (interactive()) {
  # Watch files and automatically run tests when changes are detected
  auto_test_r()
}
}
