% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localization.R
\name{localization}
\alias{localization}
\title{Localization procedure}
\usage{
localization(data, intervals, l = 0, scaling = FALSE, q = 1)
}
\arguments{
\item{data}{A numeric matrix of observations with each horizontal axis being time, and each column being the multivariate time series}

\item{intervals}{A numeric matrix of intervals with each row be a vector representing the interval}

\item{l}{A non-negative integer of order of polynomial (\code{l=0} means piecewise constant)}

\item{scaling}{A logical scalar representing whether to perform refinement for locally stationary data. Only useful when \code{l=0}}

\item{q}{A positive integer of norm}
}
\value{
The positions of estimated change-points
}
\description{
The localization procedure to detect change-points.
}
\examples{
set.seed(0)
data=rep(c(0,2,0),each=40)+rnorm(120)
d=rid(data,M=1000,tau="clustering")
cpt=localization(data,d$Good_Intervals)
print(cpt)

}
