% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descrip.R
\name{descrip}
\alias{descrip}
\alias{print.uDescriptives}
\title{Descriptive Statistics}
\usage{
descrip(
  ...,
  strata = NULL,
  subset = NULL,
  probs = c(0.25, 0.5, 0.75),
  geomInclude = FALSE,
  replaceZeroes = FALSE,
  restriction = Inf,
  above = NULL,
  below = NULL,
  labove = NULL,
  rbelow = NULL,
  lbetween = NULL,
  rbetween = NULL,
  interval = NULL,
  linterval = NULL,
  rinterval = NULL,
  lrinterval = NULL
)
}
\arguments{
\item{\dots}{an arbitrary number of variables for which descriptive statistics 
are desired. The arguments can be vectors, matrices, or lists. Individual 
columns of a matrix or elements of a list may be of class \code{numeric}, 
\code{factor}, \code{Surv}, or \code{Date}. Factor variables are converted 
to integers. Character vectors will be coerced to numeric. Variables may be 
of different lengths, unless \code{strata} or \code{subset} are non-\code{NULL}.
A single \code{data.frame} or \code{tibble} may also be entered, in which case
each variable in the object will be described.}

\item{strata}{a vector, matrix, or list of stratification variables. Descriptive 
statistics will be computed within strata defined by each unique combination 
of the stratification variables, as well as in the combined sample. 
If \code{strata} is supplied, all variables must be of that same length.}

\item{subset}{a vector indicating a subset to be used for all descriptive statistics. 
If \code{subset} is supplied, all variables must be of that same length.}

\item{probs}{a vector of probabilities between 0 and 1 indicating quantile 
estimates to be included in the descriptive statistics. Default is to compute 
25th, 50th (median) and 75th percentiles.}

\item{geomInclude}{if not \code{FALSE} (the default), includes the geometric mean 
in the descriptive statistics.}

\item{replaceZeroes}{if not \code{FALSE} (the default), this indicates a value 
to be used in place of zeroes when computing a geometric mean. If \code{TRUE}, 
a value equal to one-half the lowest nonzero value is used. If a numeric value 
is supplied, that value is used for all variables.}

\item{restriction}{a value used for computing restricted means, standard deviations, 
and geometric means with censored time-to-event data. The default value of 
\code{Inf} will cause restrictions at the highest observation. Note that the 
same value is used for all variables of class \code{Surv}.}

\item{above}{a vector of values used to dichotomize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values greater than each element of \code{above}.}

\item{below}{a vector of values used to dichotomize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values less than each element of \code{below}.}

\item{labove}{a vector of values used to dichotomize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values greater than or equal to each element of \code{labove}.}

\item{rbelow}{a vector of values used to dichotomize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values less than or equal to each element of \code{rbelow}.}

\item{lbetween}{a vector of values with \code{-Inf} and \code{Inf} appended 
is used as cutpoints to categorize variables. The descriptive statistics will 
include an estimate for each variable of the proportion of measurements with 
values between successive elements of \code{lbetween}, with the left-hand 
endpoint included in each interval.}

\item{rbetween}{a vector of values with \code{-Inf} and \code{Inf} appended 
is used as cutpoints to categorize variables. The descriptive statistics will 
include an estimate for each variable of the proportion of measurements with 
values between successive elements of \code{rbetween}, with the right-hand 
endpoint included in each interval.}

\item{interval}{a two-column matrix of values in which each row is used to 
define intervals of interest to categorize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values between two elements in a row, with neither endpoint 
included in each interval.}

\item{linterval}{a two-column matrix of values in which each row is used to 
define intervals of interest to categorize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values between two elements in a row, with the left-hand 
endpoint included in each interval.}

\item{rinterval}{a two-column matrix of values in which each row is used to 
define intervals of interest to categorize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values between two elements in a row, with the right-hand 
endpoint included in each interval.}

\item{lrinterval}{a two-column matrix of values in which each row is used to 
define intervals of interest to categorize variables. The descriptive 
statistics will include an estimate for each variable of the proportion of 
measurements with values between two elements in a row, with both endpoints 
included in each interval.}
}
\value{
An object of class \code{uDescriptives} is returned. Descriptive 
  statistics for each variable in the entire subsetted sample, as well as 
  within each stratum if any is defined, are contained in a matrix with rows 
  corresponding to variables and strata and columns corresponding to the 
  descriptive statistics. Descriptive statistics include
  \itemize{
    \item N: the number of observations.
    \item Msng: the number of observations with missing values.
    \item Mean: the mean of the nonmissing observations (this is potentially 
                  a restricted mean for right-censored time-to-event data).
    \item Std Dev: the standard deviation of the nonmissing observations 
                    (this is potentially a restricted standard deviation for 
                    right-censored time to event data).
    \item Geom Mn: the geometric mean of the nonmissing observations 
                   (this is potentially a restricted geometric mean for 
                   right-censored time to event data). Nonpositive values in 
                   the variable will generate \code{NA}, unless \code{replaceZeroes} 
                   was specified.
    \item Min: the minimum value of the nonmissing observations (this is
                 potentially restricted for right-censored time-to-event data).
    \item Quantiles: columns corresponding to the quantiles specified by \code{probs} 
                     (these are potentially restricted for right-censored 
                     time-to-event data).
    \item Max: the maximum value of the nonmissing observations (this is
                 potentially restricted for right-censored time-to-event data).
    \item Proportions: columns corresponding to the proportions as specified by
                        \code{above}, \code{below}, \code{labove}, \code{rbelow}, 
                        \code{lbetween}, \code{rbetween}, \code{interval}, 
                        \code{linterval}, \code{rinterval}, and \code{lrinterval}.
    \item restriction: the threshold for restricted means, standard deviations, 
                         and geometric means.
    \item firstEvent: the time of the first event for censored time-to-event variables.
    \item lastEvent: the time of the last event for censored time-to-event variables.
    \item isDate: an indicator that the variable is a \code{Date} object.
  }
}
\description{
Produces table of relevant descriptive statistics for an arbitrary number of
variables of class \code{integer}, \code{numeric}, \code{Surv}, \code{Date},
or \code{factor}. Descriptive statistics can be obtained within strata, and
the user can specify that only a subset of the data be used. Descriptive
statistics include the count of observations, the count of cases with
missing values, the mean, standard deviation, geometric mean, minimum, and
maximum. The user can specify arbitrary quantiles to be estimated, as well
as specifying the estimation of proportions of observations within specified
ranges.
}
\details{
This function
depends on the \code{survival} R package. You should execute
\code{library(survival)} if that library has not been previously installed.
Quantiles are computed for uncensored data using the default method in
\code{quantile()}. For variables of class \code{factor}, descriptive
statistics will be computed using the integer coding for factors. For
variables of class \code{Surv}, estimated proportions and quantiles will be
computed from Kaplan-Meier estimates, as will be restricted means,
restricted standard deviations, and restricted geometric means. For
variables of class \code{Date}, estimated proportions will be labeled using
the Julian date since January 1, 1970.
}
\examples{

# Read in the data
data(mri) 

# Create the table 
descrip(mri)

}
