% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.risks}
\alias{confint.risks}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{risks}(
  object,
  parm,
  level = 0.95,
  bootrepeats = 1000,
  bootci = "bca",
  jacksd = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted risks model}

\item{parm}{Not used, for compatibility}

\item{level}{Optional. Confidence level. Defaults to \code{0.95}.}

\item{bootrepeats}{Optional and only applicable to
\code{approach = "margstd_boot"}: bootstrap repeats. Defaults to
\code{1000}. Consider increasing.}

\item{bootci}{Optional and only applicable to
\code{approach = "margstd_boot"}: type of bootstrap confidence interval.
Available methods:
\itemize{
\item \code{"bca"} Default. Parametric BCa (bias-corrected accelerated)
bootstrap confidence intervals.
\item \code{"normal"} Parametric normality-based confidence intervals,
which require lower repeat numbers but are less accurate and
may result in invalid results for ratios.
\item \code{"nonpar"} Non-parametric BCa confidence intervals,
which should be used with caution because of the risk
of sparse-data bias with non-parametric bootstrapping.
}}

\item{jacksd}{Optional and only applicable to
\code{approach = "margstd_boot"}: Also return jackknife estimate of
Monte-Carlo error for the confidence limits? Only functional with BCa
confidence intervals. Defaults to \code{FALSE}.}

\item{...}{Passed on.}
}
\value{
Matrix: First column, lower bound; second column, upper bound.
}
\description{
Estimates confidence intervals for the fitted risks model. For binomial
models, large-sample confidence intervals, not profile likelihood, are used.
}
\examples{
confint(
  riskratio(
    formula = death ~ stage + receptor,
    data = breastcancer))
}
