% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_org}
\alias{pal_org}
\title{Original color palette.}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal_org
}
\description{
\code{pal_org} is a copy of \code{\link{pal}}
(to retrieve original set of colors in case
\code{\link{pal}} is changed).
}
\details{
See \code{\link{pal}} for default color information.

Assign \code{pal <- pal_org} to re-set default color scheme
throughout the \bold{riskyr} package.
}
\examples{
pal_org        # shows all color names and current values
pal_org["hi"]  # shows the current color for hits (true positives, TP)
pal_org["hi"] <- "gold" # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other color palettes: 
\code{\link{pal_bw}},
\code{\link{pal_bwp}},
\code{\link{pal_crisk}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}}

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal}},
\code{\link{pal_bw}},
\code{\link{pal_bwp}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{prob}},
\code{\link{txt}},
\code{\link{txt_TF}},
\code{\link{txt_org}}
}
\concept{color palettes}
\concept{lists containing current scenario information}
\keyword{datasets}
