% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_name_usage.R
\name{italic_name_usage}
\alias{italic_name_usage}
\title{Get details of species names}
\usage{
italic_name_usage(sp_names)
}
\arguments{
\item{sp_names}{Character vector of matched names or accepted names}
}
\value{
A data frame with columns:
\describe{
\item{input_name}{The scientific name provided as input}
\item{scientific_name_id}{Unique identifier of ITALIC for the scientific name}
\item{index_fungorum_id}{Corresponding Index Fungorum identifier}
\item{scientific_name_full}{Complete scientific name including authority}
\item{scientific_name}{Scientific name without authority}
\item{authorship}{Author of the name}
\item{notes}{Additional notes about the taxon, if any}
\item{rank}{Taxonomic rank of the name}
\item{status}{Taxonomic status ('accepted', 'synonym' or 'basionym')}
\item{related_accepted_name_id}{ID of the currently accepted name related to the input name in ITALIC}
\item{related_accepted_name}{Full accepted name}
\item{related_taxon_id}{ID of the related taxon in ITALIC}
}
}
\description{
Retrieves information for a scientific name used in ITALIC, including name id,
taxonomic status, Index Fungorum id and related taxon id.
}
\note{
Before using this function with a list of names, first obtain their matched names or
accepted names using \code{italic_match()}.
Example workflow:
\preformatted{
      names_matched <- italic_match(your_names)
      name_data <- italic_name_usage(names_matched$matched_name)
      # or
      accepted_name_data <- italic_name_usage(names_matched$accepted_name)
      }
}
\examples{
\dontrun{
italic_name_usage(c("Cetraria islandica (L.) Ach. subsp. islandica", "Secoliga annexa Arnold"))
}

}
