/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.data;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.BaseSeqCursor;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;

public final class InternalBlockCursors {
    @Generated
    private InternalBlockCursors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class BlockM1DoubleVectorCursor
    extends BlockM1DoubleSeqCursor
    implements DoubleSeqCursor.OnMutable {
        public BlockM1DoubleVectorCursor(double[] data, int leftPos) {
            super(data, leftPos);
        }

        @Override
        public void setAndNext(double newValue) {
            this.data[this.cursor--] = newValue;
        }

        @Override
        public void applyAndNext(DoubleUnaryOperator fn) {
            this.data[this.cursor] = fn.applyAsDouble(this.data[this.cursor]);
            --this.cursor;
        }
    }

    public static class BlockM1DoubleSeqCursor
    extends BlockM1BaseSeqCursor
    implements DoubleSeqCursor {
        protected final double[] data;

        public BlockM1DoubleSeqCursor(double[] data, int leftPos) {
            super(leftPos);
            this.data = data;
        }

        @Override
        public double getAndNext() {
            return this.data[this.cursor--];
        }
    }

    private static class BlockM1BaseSeqCursor
    implements BaseSeqCursor {
        protected final int leftPos;
        protected int cursor;

        public BlockM1BaseSeqCursor(int leftPos) {
            this.leftPos = leftPos;
            this.cursor = leftPos;
        }

        @Override
        public void moveTo(int index) {
            this.cursor = this.leftPos - index;
        }

        @Override
        public void skip(int n) {
            this.cursor -= n;
        }
    }

    public static class BlockP1DoubleVectorCursor
    extends BlockP1DoubleSeqCursor
    implements DoubleSeqCursor.OnMutable {
        public BlockP1DoubleVectorCursor(double[] data, int leftPos) {
            super(data, leftPos);
        }

        @Override
        public void setAndNext(double newValue) {
            this.data[this.cursor++] = newValue;
        }

        @Override
        public void applyAndNext(DoubleUnaryOperator fn) {
            this.data[this.cursor] = fn.applyAsDouble(this.data[this.cursor]);
            ++this.cursor;
        }
    }

    public static class BlockP1DoubleSeqCursor
    extends BlockP1BaseSeqCursor
    implements DoubleSeqCursor {
        protected final double[] data;

        public BlockP1DoubleSeqCursor(double[] data, int leftPos) {
            super(leftPos);
            this.data = data;
        }

        @Override
        public double getAndNext() {
            return this.data[this.cursor++];
        }
    }

    private static class BlockP1BaseSeqCursor
    implements BaseSeqCursor {
        protected final int leftPos;
        protected int cursor;

        public BlockP1BaseSeqCursor(int leftPos) {
            this.leftPos = leftPos;
            this.cursor = leftPos;
        }

        @Override
        public void moveTo(int index) {
            this.cursor = this.leftPos + index;
        }

        @Override
        public void skip(int n) {
            this.cursor += n;
        }
    }

    public static class BlockDoubleVectorCursor
    extends BlockDoubleSeqCursor
    implements DoubleSeqCursor.OnMutable {
        public BlockDoubleVectorCursor(double[] data, int inc, int leftPos) {
            super(data, inc, leftPos);
        }

        @Override
        public void setAndNext(double newValue) {
            this.data[this.cursor] = newValue;
            this.cursor += this.inc;
        }

        @Override
        public void applyAndNext(DoubleUnaryOperator fn) {
            this.data[this.cursor] = fn.applyAsDouble(this.data[this.cursor]);
            this.cursor += this.inc;
        }
    }

    public static class BlockDoubleSeqCursor
    extends BlockBaseSeqCursor
    implements DoubleSeqCursor {
        protected final double[] data;

        public BlockDoubleSeqCursor(double[] data, int inc, int leftPos) {
            super(inc, leftPos);
            this.data = data;
        }

        @Override
        public double getAndNext() {
            double result = this.data[this.cursor];
            this.cursor += this.inc;
            return result;
        }
    }

    private static class BlockBaseSeqCursor
    implements BaseSeqCursor {
        protected final int inc;
        protected final int leftPos;
        protected int cursor;

        public BlockBaseSeqCursor(int inc, int leftPos) {
            this.inc = inc;
            this.leftPos = leftPos;
            this.cursor = leftPos;
        }

        @Override
        public void moveTo(int index) {
            this.cursor = this.leftPos + this.inc * index;
        }

        @Override
        public void skip(int n) {
            this.cursor += this.inc * n;
        }
    }
}

