/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import lombok.Generated;

public final class LowerTriangularMatrix {
    public static void randomize(FastMatrix M, RandomNumberGenerator rng) {
        M.set((r, c) -> c > r ? 0.0 : rng.nextDouble());
    }

    public static void solveXL(FastMatrix L, FastMatrix B) throws MatrixException {
        LowerTriangularMatrix.solveXL(L, B, 0.0);
    }

    public static void solveXL(FastMatrix L, FastMatrix B, double zero) throws MatrixException {
        int nc = B.getColumnsCount();
        if (nc != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator rows = B.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            LowerTriangularMatrix.solveLtx(L, r.getStorage(), r.getStartPosition(), r.getIncrement(), zero);
        }
    }

    public static void solveX1L(FastMatrix L, FastMatrix B) throws MatrixException {
        int nc = B.getColumnsCount();
        if (nc != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator rows = B.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            LowerTriangularMatrix.solveL1tx(L, r.getStorage(), r.getStartPosition(), r.getIncrement());
        }
    }

    public static void solveLx(FastMatrix L, DataBlock x, double zero) {
        LowerTriangularMatrix.solveLx(L, x.getStorage(), x.getStartPosition(), x.getIncrement(), zero);
    }

    public static void solveLx(FastMatrix L, DataBlock x) {
        LowerTriangularMatrix.solveLx(L, x.getStorage(), x.getStartPosition(), x.getIncrement(), 0.0);
    }

    public static void solveL1x(FastMatrix L, DataBlock x) {
        LowerTriangularMatrix.solveL1x(L, x.getStorage(), x.getStartPosition(), x.getIncrement());
    }

    public static void solvexL(FastMatrix L, DataBlock x) {
        LowerTriangularMatrix.solveLtx(L, x.getStorage(), x.getStartPosition(), x.getIncrement(), 0.0);
    }

    public static void solvexL1(FastMatrix L, DataBlock x) {
        LowerTriangularMatrix.solveL1tx(L, x.getStorage(), x.getStartPosition(), x.getIncrement());
    }

    public static void solvexL(FastMatrix L, DataBlock x, double zero) {
        LowerTriangularMatrix.solveLtx(L, x.getStorage(), x.getStartPosition(), x.getIncrement(), zero);
    }

    public static void solveXLt(FastMatrix L, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getColumnsCount();
        if (nr != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator rows = M.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            LowerTriangularMatrix.solveLx(L, r.getStorage(), r.getStartPosition(), r.getIncrement(), zero);
        }
    }

    public static void solveXLt(FastMatrix L, FastMatrix M) throws MatrixException {
        LowerTriangularMatrix.solveXLt(L, M, 0.0);
    }

    public static void solveLtX(FastMatrix L, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getRowsCount();
        if (nr != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator cols = M.columnsIterator();
        while (cols.hasNext()) {
            DataBlock c = cols.next();
            LowerTriangularMatrix.solveLtx(L, c.getStorage(), c.getStartPosition(), 1, zero);
        }
    }

    public static void solveLtX(FastMatrix L, FastMatrix M) throws MatrixException {
        LowerTriangularMatrix.solveLtX(L, M, 0.0);
    }

    public static void solveLX(FastMatrix L, FastMatrix M) throws MatrixException {
        LowerTriangularMatrix.solveLX(L, M, 0.0);
    }

    public static void solveLX(FastMatrix L, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getRowsCount();
        int nc = M.getColumnsCount();
        if (nr != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        double[] pb = M.getStorage();
        int start = M.getStartPosition();
        int lda = M.getColumnIncrement();
        int bmax = start + nc * lda;
        for (int b = start; b < bmax; b += lda) {
            LowerTriangularMatrix.solveLx(L, pb, b, 1, zero);
        }
    }

    public static void solveL1X(FastMatrix L, FastMatrix M) throws MatrixException {
        int nr = M.getRowsCount();
        int nc = M.getColumnsCount();
        if (nr != L.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        double[] pb = M.getStorage();
        int start = M.getStartPosition();
        int lda = M.getColumnIncrement();
        int bmax = start + nc * lda;
        for (int b = start; b < bmax; b += lda) {
            LowerTriangularMatrix.solveL1x(L, pb, b, 1);
        }
    }

    public static void Lx(FastMatrix L, DataBlock x) {
        int incx = x.getIncrement();
        if (incx == 1) {
            LowerTriangularMatrix.Lx(L, x.getStorage(), x.getStartPosition());
        } else {
            LowerTriangularMatrix.Lx(L, x.getStorage(), x.getStartPosition(), x.getIncrement());
        }
    }

    public static void xL(FastMatrix L, DataBlock x) {
        int incx = x.getIncrement();
        if (incx == 1) {
            LowerTriangularMatrix.Ltx(L, x.getStorage(), x.getStartPosition());
        } else {
            LowerTriangularMatrix.Ltx(L, x.getStorage(), x.getStartPosition(), x.getIncrement());
        }
    }

    public static void LM(FastMatrix L, FastMatrix M) {
        int mstart = M.getStartPosition();
        int mlda = M.getColumnIncrement();
        int n = M.getColumnsCount();
        double[] pm = M.getStorage();
        int cmax = mstart + mlda * n;
        for (int c = mstart; c < cmax; c += mlda) {
            LowerTriangularMatrix.Lx(L, pm, c);
        }
    }

    public static void ML(FastMatrix L, FastMatrix M) {
        int mstart = M.getStartPosition();
        int mlda = M.getColumnIncrement();
        int m = M.getRowsCount();
        double[] pm = M.getStorage();
        int cmax = mstart + m;
        for (int c = mstart; c < cmax; ++c) {
            LowerTriangularMatrix.Ltx(L, pm, c, mlda);
        }
    }

    public static void LtM(FastMatrix L, FastMatrix M) {
        DataBlockIterator cols = M.columnsIterator();
        while (cols.hasNext()) {
            DataBlock c = cols.next();
            LowerTriangularMatrix.Ltx(L, c.getStorage(), c.getStartPosition());
        }
    }

    public static void MLt(FastMatrix L, FastMatrix M) {
        DataBlockIterator rows = M.rowsIterator();
        while (rows.hasNext()) {
            DataBlock c = rows.next();
            LowerTriangularMatrix.Lx(L, c.getStorage(), c.getStartPosition(), c.getIncrement());
        }
    }

    public static void toLower(FastMatrix M) {
        int n;
        int m = M.getRowsCount();
        if (m != (n = M.getColumnsCount())) {
            throw new MatrixException("m_err_square");
        }
        if (n == 1) {
            return;
        }
        double[] x = M.getStorage();
        int lda = M.getColumnIncrement();
        int start = M.getStartPosition();
        int ic = start;
        for (int c = 0; c < n; ++c) {
            int id = ic + c;
            for (int iu = ic; iu < id; ++iu) {
                x[iu] = 0.0;
            }
            ic += lda;
        }
    }

    public static FastMatrix inverse(FastMatrix L) throws MatrixException {
        if (L.diagonal().anyMatch(x -> x == 0.0)) {
            throw new MatrixException("m_err_sing");
        }
        int n = L.getRowsCount();
        if (n != L.getColumnsCount()) {
            throw new MatrixException("m_err_square");
        }
        FastMatrix IL = FastMatrix.identity(n);
        LowerTriangularMatrix.solveLX(L, IL);
        return IL;
    }

    public static LogSign logDeterminant(FastMatrix L) {
        return LogSign.of((DoubleSeq)L.diagonal());
    }

    public static double determinant(FastMatrix L) {
        LogSign ls = LowerTriangularMatrix.logDeterminant(L);
        if (ls == null) {
            return 0.0;
        }
        double val = Math.exp(ls.getValue());
        return ls.isPositive() ? val : -val;
    }

    private static void Lx(FastMatrix L, double[] px, int startx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int xend = startx + n;
        int li = start + (n - 1) * (lda + 1);
        int xi = xend - 1;
        while (li >= start) {
            double z = px[xi];
            if (z != 0.0) {
                px[xi] = pl[li] * z;
                int xj = xi + 1;
                int lj = li + 1;
                while (xj < xend) {
                    int n2 = xj++;
                    px[n2] = px[n2] + pl[lj] * z;
                    ++lj;
                }
            }
            li -= lda + 1;
            --xi;
        }
    }

    private static void Lx(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int xend = startx + incx * n;
        int li = start + (n - 1) * (lda + 1);
        int xi = xend - incx;
        while (li >= start) {
            double z = px[xi];
            if (z != 0.0) {
                px[xi] = pl[li] * z;
                int xj = xi + incx;
                int idx = li + 1;
                while (xj != xend) {
                    int n2 = xj;
                    px[n2] = px[n2] + pl[idx] * z;
                    xj += incx;
                    ++idx;
                }
            }
            li -= lda + 1;
            xi -= incx;
        }
    }

    private static void Ltx(FastMatrix L, double[] px, int startx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int xend = startx + n;
        int ixj = startx;
        int u0 = start;
        while (ixj < xend) {
            double tmp = px[ixj] * pl[u0];
            int ix = ixj + 1;
            int iu = u0 + 1;
            while (ix < xend) {
                tmp += px[ix] * pl[iu];
                ++ix;
                ++iu;
            }
            px[ixj] = tmp;
            ++ixj;
            u0 += lda + 1;
        }
    }

    private static void Ltx(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int xend = startx + n * incx;
        int du = lda + 1;
        int ixj = startx;
        int u0 = start;
        while (ixj != xend) {
            double tmp = px[ixj] * pl[u0];
            int ix = ixj + incx;
            int iu = u0 + 1;
            while (ix != xend) {
                tmp += px[ix] * pl[iu];
                ix += incx;
                ++iu;
            }
            px[ixj] = tmp;
            ixj += incx;
            u0 += du;
        }
    }

    private static void solveLx(FastMatrix L, double[] px, int startx, int incx, double zero) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int dl = lda + 1;
        if (incx == 1) {
            int xend = startx + n;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                double d = pl[il];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[ix] = 0.0;
                } else {
                    double c;
                    px[ix] = c = t / d;
                    int jx = ix + 1;
                    int jl = il + 1;
                    while (jx < xend) {
                        int n2 = jx++;
                        px[n2] = px[n2] - c * pl[jl];
                        ++jl;
                    }
                }
                ++ix;
                il += dl;
            }
        } else {
            int xend = startx + n * incx;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                double d = pl[il];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[ix] = 0.0;
                } else {
                    double c;
                    px[ix] = c = t / d;
                    int jx = ix + incx;
                    int jl = il + 1;
                    while (jx < xend) {
                        int n3 = jx;
                        px[n3] = px[n3] - c * pl[jl];
                        jx += incx;
                        ++jl;
                    }
                }
                ix += incx;
                il += lda + 1;
            }
        }
    }

    private static void solveL1x(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        int dl = lda + 1;
        if (incx == 1) {
            int xend = startx + n;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                int jx = ix + 1;
                int jl = il + 1;
                while (jx < xend) {
                    int n2 = jx++;
                    px[n2] = px[n2] - t * pl[jl];
                    ++jl;
                }
                ++ix;
                il += dl;
            }
        } else {
            int xend = startx + n * incx;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                int jx = ix + incx;
                int jl = il + 1;
                while (jx < xend) {
                    int n3 = jx;
                    px[n3] = px[n3] - t * pl[jl];
                    jx += incx;
                    ++jl;
                }
                ix += incx;
                il += lda + 1;
            }
        }
    }

    private static void solveLtx(FastMatrix L, double[] px, int startx, int incx, double zero) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int jx = startx + n - 1;
            int jl = start + (n - 1) * (lda + 1);
            while (jx >= startx) {
                double t = px[jx];
                int ix = jx + 1;
                int il = jl + 1;
                while (ix < xend) {
                    t -= pl[il] * px[ix];
                    ++ix;
                    ++il;
                }
                double d = pl[jl];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[jx] = 0.0;
                } else {
                    px[jx] = t / d;
                }
                --jx;
                jl -= lda + 1;
            }
        } else {
            int xend;
            int jx = xend = startx + n * incx;
            int jl = start + (n - 1) * (lda + 1);
            while (jx != startx) {
                double t = px[jx -= incx];
                int ix = jx + incx;
                int il = jl + 1;
                while (ix != xend) {
                    t -= pl[il] * px[ix];
                    ix += incx;
                    ++il;
                }
                double d = pl[jl];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[jx] = 0.0;
                } else {
                    px[jx] = t / d;
                }
                jl -= lda + 1;
            }
        }
    }

    private static void solveL1tx(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int jx = startx + n - 1;
            int jl = start + (n - 1) * (lda + 1);
            while (jx >= startx) {
                double t = 0.0;
                int ix = jx + 1;
                int il = jl + 1;
                while (ix < xend) {
                    t += pl[il] * px[ix];
                    ++ix;
                    ++il;
                }
                int n2 = jx--;
                px[n2] = px[n2] - t;
                jl -= lda + 1;
            }
        } else {
            int xend;
            int jx = xend = startx + n * incx;
            int jl = start + (n - 1) * (lda + 1);
            while (jx != startx) {
                double t = 0.0;
                int ix = (jx -= incx) + incx;
                int il = jl + 1;
                while (ix != xend) {
                    t += pl[il] * px[ix];
                    ix += incx;
                    ++il;
                }
                int n3 = jx;
                px[n3] = px[n3] - t;
                jl -= lda + 1;
            }
        }
    }

    @Generated
    private LowerTriangularMatrix() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

