% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{arima_model}
\alias{arima_model}
\title{ARIMA Model}
\usage{
arima_model(name = "arima", ar = 1, delta = 1, ma = 1, variance = 1)
}
\arguments{
\item{name}{Name of the model.}

\item{ar}{coefficients of the regular auto-regressive polynomial (1 + ar(1)B + ar(2)B + ...). True signs.}

\item{delta}{non stationary auto-regressive polynomial.}

\item{ma}{coefficients of the regular moving average polynomial (1 + ma(1)B + ma(2)B + ...). True signs.}

\item{variance}{variance.}
}
\value{
a \code{"JD3_ARIMA"} model.
}
\description{
ARIMA Model
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
model <- arima_model("trend", ar = c(1, -.8), delta = c(1, -1), ma = c(1, -.5), var = 100)
\dontshow{\}) # examplesIf}
}
