% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{stock_td}
\alias{stock_td}
\title{Trading day Regressor for Stock series}
\usage{
stock_td(frequency, start, length, s, w = 31)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{w}{indicates day of the month when inventories and other stocks are reported.
(to denote the last day of the month enter 31).}
}
\value{
Time series (object of class \code{c("ts","mts","matrix")}).
}
\description{
Allows to generate a specific regressor for correcting trading days effects in Stock series.
}
\details{
The regressor will have the value -1 if the w-th day is a Sunday, 1 if it is a Monday as 0 otherwise.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
stock_td(frequency = 12L, start = c(1990L, 1L), length = 480L, w = 1L)
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{calendar_td}}
}
