% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramoseats.R
\name{terror}
\alias{terror}
\title{TERROR Quality Control of Outliers}
\usage{
terror(
  ts,
  spec = c("trfull", "tr0", "tr1", "tr2", "tr3", "tr4", "tr5"),
  nback = 1,
  context = NULL
)
}
\arguments{
\item{ts}{a univariate time series.}

\item{spec}{the model specification. Can be either the name of a predefined
specification or a user-defined specification.}

\item{nback}{number of last observations considered for the quality check.}

\item{context}{the dictionary of variables.}
}
\value{
a \code{mts} object with 7 variables:

\enumerate{
\item \strong{actual}: the actual data at the end of the series;
\item \strong{forecast}: the forecast of the actual data at the end of the
series;
\item \strong{error}: the absolute errors (= observed - forecasts);
\item \strong{rel.error}: relative errors ("scores") : ratios between the
forecast errors and the standard deviation of the forecasts of the last
observations (positive values mean under-estimation);
\item \strong{raw}: the transformed series. More especially, if the chosen
model implies a log-transformation, the values are obtained after a
log-transformation. Other transformations, such leap year corrections or
length-of periods corrections may also be used;
\item \strong{fraw}: the forecast of the transformed series.;
\item \strong{efraw}: the absolute errors of the transformed series.
}
}
\description{
TRAMO for ERRORs (TERROR) controls the quality of the data by checking outliers at the end of the series
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
terror(rjd3toolkit::ABS$X0.2.09.10.M, nback = 2)
}
\dontshow{\}) # examplesIf}
}
