% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rmd.R
\name{create_rmd}
\alias{create_rmd}
\alias{create_rmd.SA}
\alias{create_rmd.jSA}
\alias{create_rmd.workspace}
\alias{create_rmd.multiprocessing}
\alias{create_rmd.sa_item}
\title{Create and render 'rmarkdown' file}
\usage{
create_rmd(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...
)

\method{create_rmd}{SA}(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...
)

\method{create_rmd}{jSA}(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...
)

\method{create_rmd}{workspace}(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...
)

\method{create_rmd}{multiprocessing}(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...,
  workspace
)

\method{create_rmd}{sa_item}(
  x,
  output_file,
  output_format = "pdf_document",
  preprocessing_fun = print_preprocessing,
  decomposition_fun = print_decomposition,
  diagnostics_fun = print_diagnostics,
  title = "Seasonal adjustment summary",
  knitr_chunk_opts = list(fig.pos = "h", echo = FALSE, results = "asis", fig.cap =
    "S-I Ratio"),
  ...,
  workspace
)
}
\arguments{
\item{x}{the object to render: it can be a \code{"SA"}, \code{"jSA"}, \code{"sa_item"},
\code{"multiprocessing"} or \code{"workspace"} object}

\item{output_file}{the name of the output `rmarkdown` file.}

\item{output_format}{the R Markdown output format to convert to: \code{"pdf_document"} for
a pdf output, \code{"html_document"} for a HTML output. 
See \link[rmarkdown]{render} for more details.}

\item{preprocessing_fun}{the function used to print the preprocessing. 
\link{print_preprocessing} by default. 
If \code{preprocessing_fun = NULL} the function is not used.}

\item{decomposition_fun}{the function used to print the decomposition 
\link{print_decomposition} by default.
If \code{decomposition_fun = NULL} the function is not used.}

\item{diagnostics_fun}{the function used to print the diagnostics 
\link{print_diagnostics} by default.
If \code{diagnostics_fun = NULL} the function is not used.}

\item{title}{the title of the R Markdown document.}

\item{knitr_chunk_opts}{options for R code chunks.
See \link[knitr]{opts_chunk} for more details.}

\item{...}{other arguments to pass to \link[rmarkdown]{render}.}

\item{workspace}{the workspace. Only used when \code{x} is a  \code{"sa_item"} or 
\code{"multiprocessing"}.}
}
\description{
Function to create a 'rmarkdown' file with all the output and render it
}
\examples{
\donttest{
ipi <- RJDemetra::ipi_c_eu[, "FR"]
jsa_x13 <- RJDemetra::jx13(ipi)

output_file <- tempfile(fileext = ".Rmd")
create_rmd(jsa_x13, output_file, output_format = "pdf_document")
# To directly open the pdf:
browseURL(sub(".Rmd",".pdf", output_file, fixed = TRUE))


# To create a pdf from a workspace:
jsa_ts <- jtramoseats(ipi)
wk <- new_workspace()
mp <- new_multiprocessing(wk, "sa1")
add_sa_item(wk, "sa1", jsa_x13, "X13")
add_sa_item(wk, "sa1", jsa_ts, "TramoSeats")

# It's important to compute the workspace to be able
# to import the models
compute(wk)

output_file <- tempfile(fileext = ".Rmd")
create_rmd(wk, output_file, 
           output_format = c("pdf_document", "html_document"),
           output_options = list(toc = TRUE,
                                 number_sections = TRUE))
# To open the file:
browseURL(sub(".Rmd",".pdf", output_file, fixed = TRUE))
browseURL(sub(".Rmd",".html", output_file, fixed = TRUE))
}
}
