% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{julia_assign_int}
\alias{julia_assign_int}
\title{Assign an Integer Value to a Julia Variable}
\usage{
julia_assign_int(x, value)
}
\arguments{
\item{x}{A character string. The name of the Julia variable to assign the value to.}

\item{value}{The R object to assign to the Julia variable. This will be passed to Julia.}
}
\value{
Invisibly returns `NULL`. The main effect is side-effects in the Julia session.
}
\description{
This function wraps `JuliaCall::julia_assign` to assign a value from R to a Julia variable,
and then explicitly casts the variable to the `Integer` type in Julia.
}
\details{
The function first assigns the value from R to a variable named `x` in the Julia session
using `JuliaCall::julia_assign`. It then forces Julia to cast the variable to the
`Integer` type using Julia's `Integer()` constructor.

Note: This function assumes that the `value` provided is compatible with Julia's `Integer` type.
If it is not, an error will be thrown by Julia.
}
\examples{
\dontrun{
julia_assign_int("x", 3.5)  # Will be cast to 3L in Julia
JuliaCall::julia_eval("x")  # Returns 3 (as Integer in Julia)
}

}
