% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{compress.rle}
\alias{compress.rle}
\title{Compress the \code{\link{rle}} object by merging adjacent runs}
\usage{
\method{compress}{rle}(x, ...)
}
\arguments{
\item{x}{an \code{\link{rle}} object.}

\item{...}{additional objects; if given, all arguments are
concatenated.}
}
\description{
Compress the \code{\link{rle}} object by merging adjacent runs
}
\note{
Since \code{\link{rle}} stores run lengths as integers, \code{\link{compress.rle}}
will not merge runs that add up to lengths greater than what can
be represented by a 32-bit signed integer
(\Sexpr{.Machine$integer.max}).
}
\examples{

x <- rle(as.logical(rbinom(10,1,.7)))
y <- rle(as.logical(rbinom(10,1,.3)))

stopifnot(identical(rle(inverse.rle(x)&inverse.rle(y)),compress(x&y)))

big <- structure(list(lengths=as.integer(rep(.Machine$integer.max/4,6)),
                      values=rep(TRUE,6)), class="rle")

stopifnot(all(aggregate(as.numeric(lengths)~values,
                        data=as.data.frame(unclass(big)),FUN=sum)
              ==
              aggregate(as.numeric(lengths)~values,
                        data=as.data.frame(unclass(compress(big))),
                        FUN=sum)))
}
