% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm.r
\name{Quantile.blrm}
\alias{Quantile.blrm}
\title{Function Generator for Quantiles of Y for \code{\link[=blrm]{blrm()}}}
\usage{
\method{Quantile}{blrm}(object, codes = FALSE, posterior.summary = c("mean", "median"), ...)
}
\arguments{
\item{object}{a \code{\link[=blrm]{blrm()}} fit}

\item{codes}{if \code{TRUE}, use the integer codes \eqn{1,2,\ldots,k} for the \eqn{k}-level response in computing the quantile}

\item{posterior.summary}{defaults to posterior mean; may also specify \code{"median"}.  Must be consistent with the summary used when creating \code{lp}.}

\item{...}{ignored}
}
\value{
an R function
}
\description{
Creates a function to turn a posterior summarized linear predictor lp (e.g. using posterior mean of intercepts and slopes) computed at the reference intercept into e.g. an estimate of a quantile of Y using the posterior mean of all the intercepts.  \code{lptau} must be provided when call the created function if the model is a partial proportional odds model.
}
\author{
Frank Harrell
}
