% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCcontrolledVocabulary}
\alias{MzQCcontrolledVocabulary}
\alias{MzQCcontrolledVocabulary-class}
\title{A controlled vocabulary document, usually pointing to an .obo file}
\description{
A controlled vocabulary document, usually pointing to an .obo file

A controlled vocabulary document, usually pointing to an .obo file
}
\examples{
  MzQCcontrolledVocabulary$new(
    "Proteomics Standards Initiative Quality Control Ontology",
    "https://github.com/HUPO-PSI/psi-ms-CV/releases/download/v4.1.129/psi-ms.obo",
    "4.1.129")

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Full name of the controlled vocabulary.}

\item{\code{uri}}{Publicly accessible URI of the controlled vocabulary.}

\item{\code{version}}{(optional) Version of the controlled vocabulary.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCcontrolledVocabulary-new}{\code{MzQCcontrolledVocabulary$new()}}
\item \href{#method-MzQCcontrolledVocabulary-isValid}{\code{MzQCcontrolledVocabulary$isValid()}}
\item \href{#method-MzQCcontrolledVocabulary-toJSON}{\code{MzQCcontrolledVocabulary$toJSON()}}
\item \href{#method-MzQCcontrolledVocabulary-fromData}{\code{MzQCcontrolledVocabulary$fromData()}}
\item \href{#method-MzQCcontrolledVocabulary-clone}{\code{MzQCcontrolledVocabulary$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCcontrolledVocabulary-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCcontrolledVocabulary-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCcontrolledVocabulary$new(
  name = NA_character_,
  uri = NA_character_,
  version = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{String value for initialization of field name}

\item{\code{uri}}{String value for initialization of field uri}

\item{\code{version}}{Optional string value for initialization of field version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCcontrolledVocabulary-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCcontrolledVocabulary-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCcontrolledVocabulary$isValid(context = "MzQCcontrolledVocabulary")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCcontrolledVocabulary-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCcontrolledVocabulary-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCcontrolledVocabulary$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCcontrolledVocabulary-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCcontrolledVocabulary-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCcontrolledVocabulary$fromData(data, context = "MzQCcontrolledVocabulary")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCcontrolledVocabulary-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCcontrolledVocabulary-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCcontrolledVocabulary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
