% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonStatsAndPlots.R
\docType{methods}
\name{plotMatricesAverage}
\alias{plotMatricesAverage}
\alias{plotMatricesAverage,rnaCrosslinkDataSet-method}
\title{plotMatricesAverage}
\usage{
plotMatricesAverage(
  cds,
  type1 = "original",
  type2 = "blank",
  directory = 0,
  a = 1,
  b = 50,
  c = 1,
  d = 50,
  h = 3
)
}
\arguments{
\item{cds}{A rnaCrosslinkDataSet object}

\item{type1}{The analysis stage to plot on the upper half of the heatmap (use 'blank' to leave this half blank)}

\item{type2}{The analysis stage to plot on the lower half of the heatmap (use 'blank' to leave this half blank)}

\item{directory}{An output directory for the heatmap (use 0 for no output)}

\item{a}{To make a subsetted plot (left value on x)}

\item{b}{To make a subsetted plot (right value on x)}

\item{c}{To make a subsetted plot (left value on y)}

\item{d}{To make a subsetted plot (right value on y)}

\item{h}{Height of image (inches) ( only useful if plotting)}
}
\value{
A heatmap of the reads in the two analysis stages chosen, with each chosen stage on a separate half of the heatmap
}
\description{
Plots a contact map of all samples for two chosen stages in the analysis, with each chosen stage on separate halves of the contact map
}
\examples{
cds = makeExamplernaCrosslinkDataSet()

plotMatricesAverage(cds,
            b = rnaSize(cds),
            d = rnaSize(cds))

}
