#' Pharmacological interventions for chronic obstructive pulmonary disease
#'
#' @description A dataset of 21 trials comparing seven pharmacologic
#'   interventions with each other and placebo in patients with chronic
#'   obstructive pulmonary disease (COPD). The exacerbation of COPD is the
#'   analysed binary outcome.
#'
#' @format A data-frame with 21 rows of arm-based data and 17 columns (maximum
#'    number of 4 arms).
#'
#' @details The interventions have been coded as follows: 1, placebo; 2,
#'   budesonide; 3, budesonide plus formoterol; 4, fluticasone; 5, fluticasone
#'   plus salmeterol; 6, formoterol; 7, salmeterol; and 8, tiotropium.
#'
#' @docType data
#' @keywords datasets
#' @name nma.baker2009
#' @usage data(nma.baker2009)
#' @source
#' Baker WL, Baker EL, Coleman CI. Pharmacologic treatments for chronic
#' obstructive pulmonary disease: a mixed-treatment comparison meta-analysis.
#' \emph{Pharmacotherapy} 2009;\bold{29}(8):891--905. doi: 10.1592/phco.29.8.891
NULL

#' Pharmacological interventions for moderately severe scalp psoriasis
#'
#' @description A dataset of 9 trials comparing six pharmacologic interventions
#'   with each other and placebo for moderately severe scalp psoriasis.
#'   The analysed binary outcome is the investigator's global assessment
#'   response at 4 weeks.
#'
#' @format A data frame with 9 rows of arm-based data and 17 columns
#'   (maximum number of 4 arms).
#'
#' @details The interventions have been coded as follows: 1, betamethasone
#'   dipropionate; 2, betamethasone valerate; 3, calcipotriol; 4, calcipotriol
#'   plus polytar; 5, capasal; 6, two-compound formulation gel; and 7, placebo.
#'
#' @docType data
#' @keywords datasets
#' @name nma.bottomley2011
#' @usage data(nma.bottomley2011)
#' @source
#' Bottomley JM, Taylor RS, Ryttov J. The effectiveness of two-compound
#' formulation calcipotriol and betamethasone dipropionate gel in the
#' treatment of moderately severe scalp psoriasis: a systematic review of direct
#' and indirect evidence. \emph{Curr Med Res Opin} 2011;\bold{27}(1):251--68.
#' doi: 10.1185/03007995.2010.541022
NULL

#' Oral antithrombotics for stroke episode
#'
#' @description A dataset of 16 trials comparing seven oral antithrombotics with
#'   each other and placebo in patients with atrial fibrillation. The analysed
#'   binary outcome is prevention of a stroke episode.
#'
#' @format A data frame with 16 rows of arm-based data and 13 columns (maximum
#'   number of 3 arms).
#'
#' @details The interventions have been coded as follows: 1, placebo;
#'   2, aspirin; 3, aspirin plus clopidogrel; 4, dabigatran 110 mg;
#'   5, dabigatran 150 mg; 6, rivaroxaban; 7, vitamin K antagonist; and
#'   8, apixaban
#'
#' @docType data
#' @keywords datasets
#' @name nma.dogliotti2014
#' @usage data(nma.dogliotti2014)
#' @source
#' Dogliotti A, Paolasso E, Giugliano RP. Current and new oral antithrombotics
#' in non-valvular atrial fibrillation: a network meta-analysis
#' of 79808 patients. \emph{Heart} 2014;\bold{100}(5):396--405.
#' doi: 10.1136/heartjnl-2013-304347
NULL

#' Topical fluoride interventions for preventing dental caries
#'
#' @description A dataset of 130 trials comparing different forms of topical
#'   fluoride interventions for preventing dental caries in children or
#'   adolescents with at least 1 year or school year. The analysed continuous
#'   outcome is the change from baseline in decayed, missing, and filled tooth
#'   surfaces. The dataset contains also multi-arm trials.
#'
#' @format A data frame with 140 rows of arm-based data and 16 columns
#'   referring to the trial number, the treatment identifier in the compared
#'   arms, the standardised mean difference and its standard error for each
#'   trial and possible comparison (in the case of multi-arm trial), the
#'   randomisation year, the standard deviation and number randomised for each
#'   arm and trial, the pooled standard deviation and the within-study
#'   covariance in multi-arm trials.
#'
#' @details The interventions have been coded as follows: 1, no treatment; 2,
#'   placebo; 3, dentifrice; 4, rinse; 5, gel; and 6, varnish
#'
#' @docType data
#' @keywords datasets
#' @name nma.fluoride.donegan2018
#' @usage data(nma.fluoride.donegan2018)
#' @source
#' Donegan S, Dias S, Tudur-Smith C, Marinho V, Welton NJ. Graphs of study
#' contributions and covariate distributions for network meta-regression.
#' \emph{Res Synth Methods} 2018;\bold{9}(2):243--60. doi: 10.1002/jrsm.1292
NULL

#' Artemether, artesunate and quinine for severe malaria
#'
#' @description A dataset of 24 two-arm trials comparing artemether, artesunate
#'   and quinine with each other in patients with severe malaria. The analysed
#'   binary outcome is death.
#'
#' @format A data frame with 24 rows of arm-based data and 11 columns referring
#'   to the trial number, the treatment identifier in the compared arms,
#'   the odds ratio in the logarithmic scale and its standard error for each
#'   trial, the average age in years and its centered version, the number of
#'   events and number randomised for each arm and trial.
#'
#' @details The interventions have been coded as follows: 1, quinine;
#'   2, artemether; and 3, artesunate
#'
#' @docType data
#' @keywords datasets
#' @name nma.malaria.donegan2018
#' @usage data(nma.malaria.donegan2018)
#' @source
#' Donegan S, Dias S, Tudur-Smith C, Marinho V, Welton NJ. Graphs of study
#' contributions and covariate distributions for network meta-regression.
#' \emph{Res Synth Methods} 2018;\bold{9}(2):243--60. doi: 10.1002/jrsm.1292
NULL

#' Antidepressants in Parkinson's disease
#'
#' @description A dataset of 11 trials comparing the effectiveness of five
#'   antidepressants and placebo in Parkinson's disease. The analysed binary
#'   outcome is the number of patients with a reduction of at least 50/% from
#'   the baseline score.
#'
#' @format A data frame with 11 rows of arm-based data and 13 columns (maximum
#'   number of 3 arms).
#'
#' @details The interventions have been coded as follows: 1, placebo;
#'   2, pramipexole; 3, serotonin-norepinephrine reuptake inhibitor;
#'   4, selective serotonin reuptake inhibitor; 5, tricyclic antidepressant; and
#'   6, pergolide.
#'
#' @docType data
#' @keywords datasets
#' @name nma.liu2013
#' @usage data(nma.liu2013)
#' @source
#' Liu J, Dong J, Wang L, Yan P, Sun S. Comparative efficacy and acceptability
#' of antidepressants in Parkinson's disease: a network meta-analysis.
#' \emph{PLoS One} 2013;\bold{8}(10):e76651.
#' doi: 10.1371/journal.pone.0076651
NULL

#' Paroxetine versus placebo for depressive disorders
#'
#' @description A pairwise meta-analysis of 4 trials comparing paroxetine with
#'   placebo for depressive disorders in children and adolescents.
#'   The analysed binary outcome is remission or response as defined in the
#'   trials.
#'
#' @format A data frame with 4 rows of arm-based data and 9 columns.
#'
#' @details The interventions have been coded as follows:
#'   1, placebo; 2, paroxetine.
#'
#' @docType data
#' @keywords datasets
#' @name pma.hetrick2012
#' @usage data(pma.hetrick2012)
#' @source
#' Hetrick SE, McKenzie JE, Cox GR, Simmons MB, Merry SN. Newer generation
#' antidepressants for depressive disorders in children and adolescents.
#' \emph{Cochrane Database Syst Rev} 2012;\bold{11}(11):CD004851.
#' doi: 10.1002/14651858.CD004851.pub3
NULL

#' Inositol versus glucose for depressive episode
#'
#' @description A pairwise meta-analysis of 4 trials comparing inositol with
#'   glucose (placebo) for depressive episode. The analysed continuous outcome
#'   is the resolution of a depressive episode using the Hamilton Depression
#'   Rating Scale.
#'
#' @format A data frame with 4 rows of arm-based data and 11 columns.
#'
#' @details The interventions have been coded as follows:
#'   1, placebo; 2, inositol.
#'
#' @docType data
#' @keywords datasets
#' @name pma.taylor2004
#' @usage data(pma.taylor2004)
#' @source
#' Taylor MJ, Wilder H, Bhagwagar Z, Geddes J. Inositol for depressive
#' disorders. \emph{Cochrane Database Syst Rev} 2004;\bold{2004}(2):CD004049.
#' doi: 10.1002/14651858.CD004049.pub2
NULL

#' Training modalities for patients with type 2 diabetes
#'
#' @description A dataset of 14 trials comparing three different training
#'   modalities (a triangle network) for patients with type 2 diabetes.
#'   The analysed continuous outcome is change from baseline in HbA1c levels.
#'
#' @format A data frame with 14 rows of arm-based data and 16 columns (maximum
#'   number of 3 arms).
#'
#' @details The interventions have been coded as follows: 1, aerobic;
#'   2, resistance; and 3, combined training;
#'
#' @docType data
#' @keywords datasets
#' @name nma.schwingshackl2014
#' @usage data(nma.schwingshackl2014)
#' @source
#' Schwingshackl L, Missbach B, Dias S, et al. M Impact of different training
#' modalities on glycaemic control and blood lipids in patients with type 2
#' diabetes: a systematic review and network meta-analysis.
#' \emph{Diabetologia} 2014;\bold{57}(9):1789--97.
#' doi: 10.1007/s00125-014-3303-z
NULL

#' Antiparkinsonian interventions for later Parkinson's disease
#'
#' @description A dataset of 29 trials comparing three antiparkinsonian
#'   interventions with placebo (a star-shaped network) in patients with later
#'   Parkinson's disease. The analysed continuous outcome is the change from
#'   baseline of patient off-time reduction.
#'
#' @format A data frame with 29 rows of arm-based data and 11 columns (maximum
#'   number of 2 arms).
#'
#' @details The interventions have been coded as follows: 1, placebo plus
#'   levodopa (PBO+LD); 2, dopamine agonist plus levodopa (DA+LD);
#'   3, catechol-O-methyl transferase inhibitors plus levodopa (COMBI+LD); and
#'   4, monoamine oxidase type B inhibitors plus levodopa (MAOBI+LD).
#'
#' @docType data
#' @keywords datasets
#' @name nma.stowe2011
#' @usage data(nma.stowe2011)
#' @source
#' Stowe R, Ives N, Clarke CE, et al. Meta-analysis of the comparative efficacy
#' and safety of adjuvant treatment to levodopa in later Parkinson's disease.
#' \emph{Mov Disord} 2011;\bold{26}(4):587--98. doi: 10.1002/mds.23517
NULL
