% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.diagnostics_function.R
\name{mcmc_diagnostics}
\alias{mcmc_diagnostics}
\title{Markov Chain Monte Carlo diagnostics}
\usage{
mcmc_diagnostics(net, par = NULL)
}
\arguments{
\item{net}{An object of S3 class \code{\link{run_metareg}},
\code{\link{run_model}}, \code{\link{run_nodesplit}},
\code{\link{run_sensitivity}}, \code{\link{run_series_meta}}, and
\code{\link{run_ume}}. See 'Value' in the functions above.}

\item{par}{A vector of at least one character string that refers to the
monitored parameters in \code{jagsfit} which is an object of S3 class
\code{\link{run_metareg}}, \code{\link{run_model}}, and
\code{\link{run_ume}}. The selected parameters will be considered in the
diagnostic plots (see 'Value'). This argument will be ignored for objects
of S3 class \code{\link{run_nodesplit}}, \code{\link{run_sensitivity}},
and \code{\link{run_series_meta}}.}
}
\value{
\code{mcmc_diagnostics} considers the following monitored parameters
  to create the barplot on the ratio of MCMC error to the posterior standard
  deviation and the barplot on the Gelman-Rubin R diagnostic:
  \item{EM}{The estimated summary effect measure.}
  \item{EM_pred}{The predicted summary effect measure.}
  \item{delta}{The estimated trial-specific effect measure.}
  \item{tau}{The between-trial standard deviation.}
  \item{direct}{The direct estimate of the split node (see 'Value' in
  \code{\link{run_nodesplit}}).}
  \item{indirect}{The indirect estimate of the split node
  (see 'Value' in \code{\link{run_nodesplit}}).}
  \item{diff}{The inconsistency factor of the split node (see 'Value' in
  \code{\link{run_nodesplit}}).}
  \item{phi}{The informative missingness parameter.}
  \item{beta}{The regression coefficient.}

  For each monitored parameter mentioned above, \code{mcmc_diagnostics} also
  returns a barplot on the ratio of MCMC error to the posterior standard
  deviation and a barplot on the Gelman-Rubin R diagnostic. Bars that
  correspond to a ratio less than 5\% are indicated in green (the
  corresponding parameters have been estimated accurately); otherwise, the
  bars are indicated in red (inaccurate estimation). Furthermore, bars that
  correspond to an R value less than 1.10 are indicated in green (the
  corresponding parameters have been converged); otherwise, the bars are
  indicated in red (convergence is not achieved).
  \code{mcmc_diagnostics} returns histograms than barplots for \code{EM} when
  \code{\link{run_sensitivity}} is considered.

  \code{mcmc_diagnostics} also uses the
  \code{\link[coda:traceplot]{traceplot}},
  \code{\link[coda:densplot]{densplot}}, and
  \code{\link[coda:autocorr.plot]{autocorr.plot}} functions of the R-package
  \href{https://CRAN.R-project.org/package=coda}{coda} to return the trace
  plots, density plots, and autocorrelation plots for all or selected
  monitored parameters through the \code{par} argument.
}
\description{
Evaluates whether convergence has been achieved for the
  monitored parameters of the Bayesian models. The Gelman-Rubin convergence
  diagnostic, the Markov Chain Monte Carl (MCMC) error and relevant
  diagnostic plots are applied.
}
\details{
For each monitored parameter, \code{mcmc_diagnostics} considers the
  R-hat and MCMC error and compares them with the thresholds 1.1 and 5\% of
  the posterior standard deviation (the rule of thumb), respectively.
  Convergence is achieved for the monitored parameter, when the R-hat is
  below the corresponding threshold. Visual inspection of the trace plots
  and posterior density of the monitored parameters should also be considered
  when drawing conclusions about convergence.
}
\examples{
data("nma.baker2009")

# Read results from 'run_nodesplit' (using the default arguments)
res <- readRDS(system.file('extdata/node_baker.rds', package = 'rnmamod'))

# Check convergence based on R-hat
mcmc_diagnostics(net = res,
                 par = c("tau", "EM[2,1]", "EM.pred[2,1]"))

}
\references{
Gelman, A, Rubin, DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136
}
\seealso{
\code{\link[coda:as.mcmc]{as.mcmc}},
  \code{\link[coda:traceplot]{traceplot}},
  \code{\link[coda:densplot]{densplot}},
  \code{\link[coda:autocorr.plot]{autocorr.plot}},
  \code{\link{run_metareg}}, \code{\link{run_model}},
  \code{\link{run_nodesplit}}, \code{\link{run_sensitivity}},
  \code{\link{run_series_meta}}, \code{\link{run_ume}}
}
\author{
{Loukia M. Spineli}
}
