% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpcPca.R
\name{bpcPca}
\alias{bpcPca}
\title{Principal component analysis based on backwards pivot coordinates}
\usage{
bpcPca(X, robust = FALSE, norm.cat = NULL)
}
\arguments{
\item{X}{object of class data.frame. Positive values only.}

\item{robust}{if TRUE, the MCD estimate is used. Defaults to FALSE.}

\item{norm.cat}{the rationing category placed at the first position in the composition. If not defined, all pairwise logratios are considered. Given in quotation marks.}
}
\value{
\item{scores}{array of scores.} 
\item{loadings}{loadings related to the pairwise logratios. The names of the rows indicate the type of the respective coordinate 
(bpc.1 - the first backwards pivot coordinate) and the logratio quantified thereby. 
E.g. bpc.1_C2.to.C1 would therefore correspond to the logratio between compositional parts C1 and C2, schematically written log(C2/C1). See Nesrstova et al. (2023) for details.} 
\item{loadings.clr}{loadings in the clr space.} 
\item{sdev}{standard deviations of the principal components.}
\item{center}{means of the pairwise logratios.}
\item{center.clr}{means of the clr coordinates.}
\item{n.obs}{number of observations.}
}
\description{
Performs classical or robust principal component analysis on system of backwards pivot coordinates and returns the result related to pairwise logratios as well as the clr representation.
}
\details{
bpcPca

The compositional data set is repeatedly expressed in a set of backwards logratio coordinates, when each set highlights one pairwise logratio (or one pairwise logratio with the selected rationing category). 
For each set, robust or classical principal component analysis is performed and loadings respective to the first backwards pivot coordinate are stored. 
The procedure results in matrix of scores (invariant to the specific coordinate system), clr loading matrix and matrix with loadings respective to pairwise logratios.
}
\examples{
data(arcticLake)

# classical estimation with all pairwise logratios:
res.cla <- bpcPca(arcticLake)
summary(res.cla)
biplot(res.cla)
head(res.cla$scores)
res.cla$loadings
res.cla$loadings.clr

# similar output as from pca CoDa
res.cla2 <- pcaCoDa(arcticLake, method="classical", solve = "eigen")
biplot(res.cla2)
head(res.cla2$scores)
res.cla2$loadings

# classical estimation focusing on pairwise logratios with clay:
res.cla.clay <- bpcPca(arcticLake, norm.cat = "clay")
biplot(res.cla.clay)

# robust estimation with all pairwise logratios:
res.rob <- bpcPca(arcticLake, robust = TRUE)
biplot(res.rob)

}
\references{
Hron, K., Coenders, G., Filzmoser, P., Palarea-Albaladejo, J., Famera, M., Matys Grygar, M. (2022). Analysing pairwise logratios revisited. Mathematical Geosciences 53, 1643 - 1666.

Nesrstova, V., Jaskova, P., Pavlu, I., Hron, K., Palarea-Albaladejo, J., Gaba, A., Pelclova, J., Facevicova, K. (2023). Simple enough, but not simpler: Reconsidering additive logratio coordinates in compositional analysis. Submitted
}
\seealso{
\code{\link{bpc}} 
\code{\link{bpcPcaTab}}
\code{\link{bpcReg}}
}
\author{
Kamila Facevicova
}
\keyword{multivariate}
