% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robReg.r
\name{robReg}
\alias{robReg}
\title{[Robust estimator for regression models}
\usage{
robReg(
  x1,
  y1,
  wf = "T",
  scale = "AAD",
  rt = rep(1, length(y1)),
  tp = 8,
  rp.max = 150,
  cg.rt = 0.01
)
}
\arguments{
\item{x1}{explanatory variable in regression (a vector or a matrix)}

\item{y1}{objective variable in regression (a vector)}

\item{wf}{weight function ("T" for Tukey's biweight, and "H" for Huber weight)}

\item{scale}{scale for residuals. "AAD"(default) or "MAD".}

\item{rt}{sample weight (default 1)}

\item{tp}{tuning parameter (tp=4, 6 or 8) for weight function.
Smaller figure is more robust.}

\item{rp.max}{The maximum number of iteration (default 150)}

\item{cg.rt}{convergence condition to stop iteration (default: cg.rt=0.001)}
}
\value{
a list with the following elements
\describe{
\item{\code{cond}}{Weight function, scale, and other arguments choosed}
\item{\code{TK}}{robustly estimated regression coefficients using Tukey's biweight}
\item{\code{HB}}{robustly estimated regression coefficients using Huber weight}
\item{\code{wt}}{final robust weights}
\item{\code{rp}}{total number of iteration}
\item{\code{s1}}{iterative changes in the sclae of residuals (AAD or MAD)}
}
}
\description{
This function is for Robust regression by the IRLS algorithm.
It integrates child functions contained in Tirls.r and Hirls.r.
}
\examples{
require(robRatio)

set.seed(4)
cov1 <- matrix(c(3, 2.8, 2.8, 3), 2, 2)
cov2 <- matrix(c(2.5, 0, 0, 3), 2, 2)
dat1 <-  MASS::mvrnorm(n=400, mu=c(100, 100), Sigma=cov1, empirical=TRUE)
dat2 <-  cbind(runif(100,  min=96, max=104),  runif(50,  min=95, max=105))
dat3 <- matrix(c(103, 103.5, 104.5, 104.8, 96, 98, 94, 95), 4, 2) 
dat <- rbind(dat1, dat2, dat3)
plot(dat)
y1 <- dat[,2]
x1 <- dat[,1]

R0  <- lm(y1~x1)        # regression by OLS                                         

o1 <- robReg(x1, y1, tp=4)  # robust regression by IRLS (more robust)
o2 <- robReg(x1, y1, tp=8)  # robust regression by IRLS (less robust)

oldpar <- par(mfrow=c(2,2))

# non-robust regression
  plot(dat, pch=20, main="non-robust regression")
  abline(R0, col="red", lwd=2)

# robust regression with coloring robust weight
  f.o1 <- rep(1, length(x1))
  f.o1[which(o1$wt < 0.8)] <- 3
  f.o1[which(o1$wt < 0.5)] <- 7
  f.o1[which(o1$wt < 0.2)] <- 2
  f.o1[which(o1$wt == 0)] <- 8

  plot(x1, y1, pch=20, col=f.o1)
  abline(R0, col="red", lty=3)
  abline(o1$TK, col="blue", lwd=2)
  abline(o2$TK, col="cyan", lwd=2)

# robust weights (more robust)
  hist(o1$wt, main="tp=4(more robust)")

# robust weights (less robust)
  hist(o2$wt, main="tp=4(less robust)")

par(oldpar)

}
