% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_data.R
\name{kobo_data}
\alias{kobo_data}
\alias{kobo_submissions}
\alias{kobo_submissions.kobo_asset}
\alias{kobo_submissions.character}
\alias{kobo_submissions.default}
\title{Get all submissions from a KoboToolbox API asset}
\usage{
kobo_data(
  x,
  lang,
  all_versions,
  colnames_label,
  select_multiple_label,
  select_multiple_sep,
  progress,
  paginate,
  page_size
)

kobo_submissions(
  x,
  lang,
  all_versions,
  colnames_label,
  select_multiple_label,
  select_multiple_sep,
  progress,
  paginate,
  page_size
)

\method{kobo_submissions}{kobo_asset}(
  x,
  lang = NULL,
  all_versions = TRUE,
  colnames_label = FALSE,
  select_multiple_label = FALSE,
  select_multiple_sep = "_",
  progress = FALSE,
  paginate = NULL,
  page_size = NULL
)

\method{kobo_submissions}{character}(
  x,
  lang = NULL,
  all_versions = TRUE,
  colnames_label = FALSE,
  select_multiple_label = FALSE,
  select_multiple_sep = "_",
  progress = FALSE,
  paginate = NULL,
  page_size = NULL
)

\method{kobo_submissions}{default}(
  x,
  lang = NULL,
  all_versions = TRUE,
  colnames_label = FALSE,
  select_multiple_label = FALSE,
  select_multiple_sep = "_",
  progress = FALSE,
  paginate = NULL,
  page_size = NULL
)
}
\arguments{
\item{x}{the asset uid or the \code{kobo_asset} object.}

\item{lang}{character, form language used for the variable and value labels.}

\item{all_versions}{logical, whether or not to include submissions from all form versions.
Default to \code{TRUE}. If \code{FALSE}, it uses the data from the latest version of the form.}

\item{colnames_label}{logical, whether or not to use variable labels
in lieu of column names based on form question names. Default to \code{FALSE}.}

\item{select_multiple_label}{logical, whether or not to replace select_multiple columns values by labels. Default to \code{FALSE}.}

\item{select_multiple_sep}{character, column and choices separator for newly created dummy variables. Default to "_".}

\item{progress}{logical, whether or not you want to see the progess via message.
Default to \code{FALSE}.}

\item{paginate}{logical, split submissions by page_size. Default to \code{NULL}.}

\item{page_size}{integer, number of submissions per page.}
}
\value{
A \code{data.frame} or A \code{dm} object if you have a repeating
group of questions. It contains the responses from the Kobotoolbox survey.
}
\description{
Get all submissions from a KoboToolbox API asset through a \code{kobo_asset} or
asset unique identifier.
}
\details{
\code{\link{kobo_data}} is the main function of \code{robotoolbox}, it is used
pull submissions from your Kobotoolbox survey. The main result is a \code{data.frame}
for regular form and you have a \code{dm} for a form with repeating groups of questions.
}
\examples{
\dontrun{
# Use your own URL and token
kobo_setup(url = "https://kf.kobotoolbox.org/",
           token = "9et1814c285w094f6v9bd629df47a1a0e81x53a0")
# Use your own unique identifier
uid <- "a9cwEQcbWqWzA5hzkjRUWi"
asset <- kobo_asset(uid)
subs <- kobo_data(asset)

if (require(dplyr)) {
 library(dplyr)
 glimpse(subs)
 }
}

}
