% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{classo}
\alias{classo}
\title{Estimate parameters of linear regression model with compositional covariates using method suggested by Pixu shi.}
\usage{
classo(Xt, y, C, we = NULL, type = 1, control = list())
}
\arguments{
\item{Xt}{CLR transformed predictor matrix.}

\item{y}{model response vector}

\item{C}{sub-compositional matrix}

\item{we}{specify weight of model parameter}

\item{type}{1/2 for l1 / l2 loss in the model}

\item{control}{a list of internal parameters controlling the model fitting}
}
\value{
\item{beta}{model parameter estimate}
}
\description{
The model uses scaled lasoo approach for model selection.
}
\examples{
library(robregcc)
library(magrittr)

data(simulate_robregcc)
X <- simulate_robregcc$X;
y <- simulate_robregcc$y
C <- simulate_robregcc$C
n <- nrow(X); p <- ncol(X); k <-  nrow(C)

# Predictor transformation due to compositional constraint:
Xt <- cbind(1,X)          # accounting for intercept in predictor
C <- cbind(0,C)            # accounting for intercept in constraint
bw <- c(0,rep(1,p))        # weight matrix to not penalize intercept 

# Non-robust regression, [Pixu Shi 2016]
control <- robregcc_option(maxiter = 5000, tol = 1e-7, lminfac = 1e-12)
fit.nr <- classo(Xt, y, C, we = bw, type = 1, control = control) 
}
\references{
Shi, P., Zhang, A. and Li, H., 2016. \emph{Regression analysis for microbiome compositional data. The Annals of Applied Statistics}, 10(2), pp.1019-1040.
}
