% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsel.R
\name{robsel}
\alias{robsel}
\title{Robust Selection}
\usage{
robsel(x, alpha = 0.9, B = 200)
}
\arguments{
\item{x}{A \code{n}-by-\code{p} data matrix}

\item{alpha}{Prespecified confidence level. Default 0.9}

\item{B}{Number of bootstrap sample. Default 200}
}
\value{
\code{lambda} Estimation of the regularization parameter for Graphical Lasso. A vector of lambda will be return if more than 1 value of alpha is provided.
}
\description{
Robust Selection algorithm for estimation of the regularization parameter for Graphical Lasso
}
\examples{
set.seed(17)
library(robsel)
x <-matrix(rnorm(50*20),ncol=20)

#Compute estimation of lambda at confidence level alpha
lambda <- robsel(x = x, alpha = 0.9, B = 200)

}
\references{
P Cisneros-Velarde, A Petersen and S-Y Oh (2020). Distributionally Robust Formulation and Model Selection for the Graphical Lasso. Proceedings of the Twenty Third International Conference on Artificial Intelligence and Statistics.
}
\seealso{
\code{\link{robsel.glasso}} for using Graphical Lasso algorithm with estimate regularization parameter lambda from Robust Selection.
}
