% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commands.R
\name{rockr.command_result}
\alias{rockr.command_result}
\title{Get result of an asynchronous command}
\usage{
rockr.command_result(conn, id, wait = FALSE, rm = TRUE)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{id}{R command ID.}

\item{wait}{Wait for the command to complete (default is FALSE).}

\item{rm}{Remove command from the list of asynchronous commands after retrieving the result (default is TRUE).}
}
\value{
The command result as an unserialized object.
}
\description{
Get the result of an asynchronous R commands in the remote R session. The command is removed from the
remote R session after this call.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
rockr.command_result(conn, '1234')
rockr.close(conn)
}
}
\seealso{
Other command functions: 
\code{\link{rockr.command_rm}()},
\code{\link{rockr.commands_rm}()},
\code{\link{rockr.commands}()},
\code{\link{rockr.command}()}
}
\concept{command functions}
